% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-colours.R
\docType{methods}
\name{setColors<-}
\alias{setColors}
\alias{setColors,RasterLayer,character,missing-method}
\alias{setColors,RasterLayer,character,numeric-method}
\alias{setColors<-}
\alias{setColors<-,Raster,missing,list-method}
\alias{setColors<-,Raster,numeric,list-method}
\alias{setColors<-,RasterLayer,missing,character-method}
\alias{setColors<-,RasterLayer,numeric,character-method}
\alias{setColours}
\title{Set colours for plotting Raster* objects.}
\usage{
setColors(object, ..., n) <- value

\S4method{setColors}{RasterLayer,numeric,character}(object, ..., n) <- value

\S4method{setColors}{RasterLayer,missing,character}(object, ..., n) <- value

\S4method{setColors}{Raster,numeric,list}(object, ..., n) <- value

\S4method{setColors}{Raster,missing,list}(object, ..., n) <- value

setColors(object, value, n)

\S4method{setColors}{RasterLayer,character,numeric}(object, value, n)

\S4method{setColors}{RasterLayer,character,missing}(object, value)
}
\arguments{
\item{object}{A \code{Raster*} object.}

\item{...}{Additional arguments to \code{colorRampPalette}.}

\item{n}{An optional vector of values specifiying the number
of levels from which to interpolate the color palette.}

\item{value}{Named list of hex color codes (e.g., from
\code{RColorBrewer::brewer.pal}), corresponding to the names
of RasterLayers in \code{x}.}
}
\value{
Returns a Raster with the \code{colortable} slot set to \code{values}.
}
\description{
\code{setColors} works as a replacement method or a normal function call.
}
\author{
Alex Chubaty
}
\seealso{
\code{\link[RColorBrewer]{brewer.pal}},
         \code{\link[grDevices]{colorRampPalette}}.
}

