% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbourhood.R
\docType{methods}
\name{wrap}
\alias{wrap}
\alias{wrap,SpatialPoints,ANY,missing-method}
\alias{wrap,SpatialPointsDataFrame,Extent,logical-method}
\alias{wrap,SpatialPointsDataFrame,Raster,logical-method}
\alias{wrap,SpatialPointsDataFrame,matrix,logical-method}
\alias{wrap,matrix,Extent,missing-method}
\alias{wrap,matrix,Raster,missing-method}
\alias{wrap,matrix,matrix,missing-method}
\title{Wrap coordinates or pixels in a torus-like fashion}
\usage{
wrap(X, bounds, withHeading)

\S4method{wrap}{matrix,Extent,missing}(X, bounds)

\S4method{wrap}{SpatialPoints,ANY,missing}(X, bounds)

\S4method{wrap}{matrix,Raster,missing}(X, bounds)

\S4method{wrap}{matrix,Raster,missing}(X, bounds)

\S4method{wrap}{matrix,matrix,missing}(X, bounds)

\S4method{wrap}{SpatialPointsDataFrame,Extent,logical}(X, bounds, withHeading)

\S4method{wrap}{SpatialPointsDataFrame,Raster,logical}(X, bounds, withHeading)

\S4method{wrap}{SpatialPointsDataFrame,matrix,logical}(X, bounds, withHeading)
}
\arguments{
\item{X}{A SpatialPoints* object, or matrix of coordinates}

\item{bounds}{Either a Raster*, Extent, or bbox object defining bounds to wrap around}

\item{withHeading}{logical. If TRUE, then the previous points must be wrapped also
so that the subsequent heading calculation will work. Default FALSE. See details.}
}
\value{
Same class as X, but with coordinates updated to reflect the wrapping
}
\description{
Generally for model development purposes.
}
\details{
If \code{withHeading} used, then X must be a \code{SpatialPointsDataFrame}
that contains two columns, x1 and y1, with the immediately previous agent
locations.
}
\examples{
library(raster)
xrange <- yrange <- c(-50, 50)
hab <- raster(extent(c(xrange, yrange)))
hab[] <- 0

# initialize caribou agents
N <- 10

# previous points
x1 <- rep(0, N)
y1 <- rep(0, N)
# initial points
starts <- cbind(x = stats::runif(N, xrange[1], xrange[2]),
                y = stats::runif(N, yrange[1], yrange[2]))

# create the caribou agent object
caribou <- SpatialPointsDataFrame(coords = starts, data = data.frame(x1, y1))


ln <- rlnorm(N, 1, 0.02) # log normal step length
sd <- 30 # could be specified globally in params

Plot(hab, zero.color = "white", new = TRUE, axes = "L")
for(i in 1:10) {
  caribou <- SpaDES::crw(agent = caribou,
                         extent = extent(hab), stepLength = ln,
                         stddev = sd, lonlat = FALSE, torus = TRUE)
  Plot(caribou, addTo = "hab", axes = TRUE)
}
}
\author{
Eliot McIntire
}

