% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapReduce.R
\docType{methods}
\name{rasterizeReduced}
\alias{rasterizeReduced}
\title{Convert reduced representation to full raster}
\usage{
rasterizeReduced(reduced, fullRaster, plotCol, mapcode = names(fullRaster),
  ...)
}
\arguments{
\item{reduced}{\code{data.frame} or \code{data.table} that has at least one
column of codes that are represented in the \code{fullRaster}.}

\item{fullRaster}{\code{RasterLayer} of codes used in \code{reduced} that represents
a spatial representation of the data}

\item{plotCol}{a character, length 1, with the name of the column in \code{reduced} that
whose value will be plotted}

\item{mapcode}{a character, length 1, with the name of the column in \code{reduced} that
is represented in \code{fullRaster}}

\item{...}{Other arguments. None used yet.}
}
\value{
A \code{RasterLayer} of with same dimensions as \code{fullRaster} representing
\code{plotCol} spatially, according to the join between the \code{mapcodeAll} contained within
\code{reduced} and \code{fullRaster}
}
\description{
Convert reduced representation to full raster
}
\examples{
library(data.table)
library(raster)
Ras <- raster(extent(0,15,0,15), res=1)
fullRas <- randomPolygons(Ras, numTypes=5, speedup=1, p=0.3)
names(fullRas) <- "mapcodeAll"
uniqueComms <- unique(fullRas)
reducedDT <- data.table(mapcodeAll=uniqueComms,
   communities=sample(1:1000,length(uniqueComms)),
   biomass=rnbinom(length(uniqueComms),mu=4000,0.4))
biomass <- rasterizeReduced(reducedDT, fullRas, "biomass")

# The default key is the layer name of the fullRas, so even
# if the reducedDT is miskeyed
setkey(reducedDT, biomass)

communities <- rasterizeReduced(reducedDT, fullRas, "communities")
setColors(communities) <- c("blue", "orange", "red")
Plot(biomass, communities, fullRas, new=TRUE)
}
\author{
Eliot McIntire
}
\seealso{
\code{\link{raster}}
}

