% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{next_day}
\alias{next_day}
\alias{next_day}
\alias{next_day,Column,character-method}
\title{next_day}
\usage{
next_day(y, x)

\S4method{next_day}{Column,character}(y, x)
}
\arguments{
\item{y}{Column to compute on.}

\item{x}{Day of the week string.}
}
\description{
Given a date column, returns the first date which is later than the value of the date column
that is on the specified day of the week.
}
\details{
For example, \code{next_day('2015-07-27', "Sunday")} returns 2015-08-02 because that is the first
Sunday after 2015-07-27.

Day of the week parameter is case insensitive, and accepts first three or two characters:
"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun".
}
\note{
next_day since 1.5.0
}
\examples{
\dontrun{
next_day(df$d, 'Sun')
next_day(df$d, 'Sunday')
}
}
\seealso{
Other datetime_funcs: \code{\link{add_months}},
  \code{\link{date_add}}, \code{\link{date_format}},
  \code{\link{date_sub}}, \code{\link{datediff}},
  \code{\link{dayofmonth}}, \code{\link{dayofyear}},
  \code{\link{from_unixtime}},
  \code{\link{from_utc_timestamp}}, \code{\link{hour}},
  \code{\link{last_day}}, \code{\link{minute}},
  \code{\link{months_between}}, \code{\link{month}},
  \code{\link{quarter}}, \code{\link{second}},
  \code{\link{to_date}}, \code{\link{to_utc_timestamp}},
  \code{\link{unix_timestamp}}, \code{\link{weekofyear}},
  \code{\link{window}}, \code{\link{year}}
}
