% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\docType{methods}
\name{saveAsTable}
\alias{saveAsTable}
\alias{saveAsTable}
\alias{saveAsTable,SparkDataFrame,character-method}
\title{Save the contents of the SparkDataFrame to a data source as a table}
\usage{
saveAsTable(df, tableName, source = NULL, mode = "error", ...)

\S4method{saveAsTable}{SparkDataFrame,character}(df, tableName, source = NULL,
  mode = "error", ...)
}
\arguments{
\item{df}{a SparkDataFrame.}

\item{tableName}{a name for the table.}

\item{source}{a name for external data source.}

\item{mode}{one of 'append', 'overwrite', 'error', 'ignore' save mode (it is 'error' by default).}

\item{...}{additional option(s) passed to the method.}
}
\description{
The data source is specified by the \code{source} and a set of options (...).
If \code{source} is not specified, the default data source configured by
spark.sql.sources.default will be used.
}
\details{
Additionally, mode is used to specify the behavior of the save operation when
data already exists in the data source. There are four modes: \cr
 append: Contents of this SparkDataFrame are expected to be appended to existing data. \cr
 overwrite: Existing data is expected to be overwritten by the contents of this
    SparkDataFrame. \cr
 error: An exception is expected to be thrown. \cr
 ignore: The save operation is expected to not save the contents of the SparkDataFrame
    and to not change the existing data. \cr
}
\note{
saveAsTable since 1.4.0
}
\examples{
\dontrun{
sparkR.session()
path <- "path/to/file.json"
df <- read.json(path)
saveAsTable(df, "myfile")
}
}
\seealso{
Other SparkDataFrame functions: \code{\link{SparkDataFrame-class}},
  \code{\link{agg}}, \code{\link{arrange}},
  \code{\link{as.data.frame}}, \code{\link{attach}},
  \code{\link{cache}}, \code{\link{coalesce}},
  \code{\link{collect}}, \code{\link{colnames}},
  \code{\link{coltypes}},
  \code{\link{createOrReplaceTempView}},
  \code{\link{crossJoin}}, \code{\link{dapplyCollect}},
  \code{\link{dapply}}, \code{\link{describe}},
  \code{\link{dim}}, \code{\link{distinct}},
  \code{\link{dropDuplicates}}, \code{\link{dropna}},
  \code{\link{drop}}, \code{\link{dtypes}},
  \code{\link{except}}, \code{\link{explain}},
  \code{\link{filter}}, \code{\link{first}},
  \code{\link{gapplyCollect}}, \code{\link{gapply}},
  \code{\link{getNumPartitions}}, \code{\link{group_by}},
  \code{\link{head}}, \code{\link{histogram}},
  \code{\link{insertInto}}, \code{\link{intersect}},
  \code{\link{isLocal}}, \code{\link{join}},
  \code{\link{limit}}, \code{\link{merge}},
  \code{\link{mutate}}, \code{\link{ncol}},
  \code{\link{nrow}}, \code{\link{persist}},
  \code{\link{printSchema}}, \code{\link{randomSplit}},
  \code{\link{rbind}}, \code{\link{registerTempTable}},
  \code{\link{rename}}, \code{\link{repartition}},
  \code{\link{sample}}, \code{\link{schema}},
  \code{\link{selectExpr}}, \code{\link{select}},
  \code{\link{showDF}}, \code{\link{show}},
  \code{\link{storageLevel}}, \code{\link{str}},
  \code{\link{subset}}, \code{\link{take}},
  \code{\link{union}}, \code{\link{unpersist}},
  \code{\link{withColumn}}, \code{\link{with}},
  \code{\link{write.df}}, \code{\link{write.jdbc}},
  \code{\link{write.json}}, \code{\link{write.orc}},
  \code{\link{write.parquet}}, \code{\link{write.text}}
}
