% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{structField}
\alias{structField}
\alias{structField.jobj}
\alias{structField.character}
\title{structField}
\usage{
structField(x, ...)

\method{structField}{jobj}(x, ...)

\method{structField}{character}(x, type, nullable = TRUE, ...)
}
\arguments{
\item{x}{the name of the field.}

\item{...}{additional argument(s) passed to the method.}

\item{type}{The data type of the field}

\item{nullable}{A logical vector indicating whether or not the field is nullable}
}
\value{
A structField object.
}
\description{
Create a structField object that contains the metadata for a single field in a schema.
}
\note{
structField since 1.4.0
}
\examples{
\dontrun{
field1 <- structField("a", "integer")
field2 <- structField("c", "string")
field3 <- structField("avg", "double")
schema <-  structType(field1, field2, field3)
df1 <- gapply(df, list("a", "c"),
              function(key, x) { y <- data.frame(key, mean(x$b), stringsAsFactors = FALSE) },
              schema)
}
}
