% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon.R
\name{shannonX}
\alias{shannonX}
\title{Shannon's entropy.}
\usage{
shannonX(data)
}
\arguments{
\item{data}{A data matrix or vector, can be numeric, factor, character, ...
If the dataset is a point pattern, \code{data} is the mark vector.}
}
\value{
Estimated probabilities for all data categories, and Shannon's entropy.
}
\description{
This function computes Shannon's entropy of a variable \eqn{X} with a finite number of categories.
}
\details{
Shannon's entropy measures the heterogeneity of a set of categorical data. It
is computed as \deqn{H(X)=\sum p(x_i) \log(1/p(x_i))} where \eqn{p(x_i)} is the
probability of occurrence of the \eqn{i}-th category, here estimated by its relative
frequency. This is both the non parametric and the maximum likelihood estimator.
Shannon's entropy varies between 0 and \eqn{\log(I)}, \eqn{I} being the
number of categories of the variable under study.
}
\examples{
#NON SPATIAL DATA
shannonX(sample(1:5, 50, replace=TRUE))

#POINT DATA
data.pp=runifpoint(100, win=square(10))
marks(data.pp)=sample(c("a","b","c"), 100, replace=TRUE)
shannonX(marks(data.pp))

#LATTICE DATA
data.lat=matrix(sample(c("a","b","c"), 100, replace=TRUE), nrow=10)
shannonX(data.lat)

}
