% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{PointShotSeasonGraphPlayer}
\alias{PointShotSeasonGraphPlayer}
\title{Generates a point based shot chart for a given player}
\usage{
PointShotSeasonGraphPlayer(Seasondata, player, Type = "Both", kernel = TRUE)
}
\arguments{
\item{Seasondata}{a data frame with the details of the season}

\item{player}{the name of the player that you want to make a graph of}

\item{Type}{either "Both" (default), for plotting every point, "Made"
to plot only the
made shots or "Missed" to plot only the missed shots.}

\item{kernel}{Logical, weather to plot or not the kernel of shots}
}
\value{
a shot chart graph
}
\description{
Creates a shot chart for a player on a given season creating a point
for each taken shot separating by colors mades and misses, also as you
can add a kernel of the frequency of usage of areas
}
\examples{
data("season2017")
#Examples with several players
PointShotSeasonGraphPlayer(season2017, player = "James Harden")
PointShotSeasonGraphPlayer(season2017, player = "DeMar DeRozan")

PointShotSeasonGraphPlayer(season2017, player = "Stephen Curry", kernel = FALSE)
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>
}
