% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso_simulation_by_heritabilitiy.R
\name{iso_simulation_by_heriability}
\alias{iso_simulation_by_heriability}
\title{A simulation fucntion for isotrophic spatial data}
\usage{
iso_simulation_by_heriability(n.row, n.col, lon.lat = FALSE, mile = FALSE,
  density.choice, density.layout = c("diagSet", "random", "equal_space",
  "p_rep"), h2, sigma_env, sigma_variety = (sigma_env * h2)/(1 - h2),
  mu_variety, mu_check = mu_variety + 1.68 * sqrt(sigma_variety),
  cov_fun = "exp", ranges = sqrt(2), simulation = 3, nugget = 0,
  mu_floor = 0, p_rep_check = 0.05)
}
\arguments{
\item{n.row}{(Mandatory) The row of the field grid}

\item{n.col}{(Mandatory) The column of the fields grid}

\item{lon.lat}{(Optional) The distance calculation is based on earth distance (if TRUE), default is FALSE}

\item{mile}{(Optional) The distance calculation is based on milage (if TRUE), default is FALSE}

\item{density.choice}{(Mandatory) The density of the checks, a vector (range from 0 to 1)}

\item{density.layout}{(Optional) The layout pattern of density, default are: 'diagonal', 'diagSet', 'random', 'equal_space', 'p_rep'. The diagSet is recommended over the diagonal at density from 0.01 to 0.35.}

\item{h2}{(Mandatory) The heritability of the simulated data, h2 = sigma_variety / (sigma_variety + sigma_env)}

\item{sigma_env}{(Mandatory) The variance of environment, (equilievent of sill)}

\item{sigma_variety}{(Optional) The variance of entry, default sigma_variety = (sigma_env * h2) / (1 - h2)}

\item{mu_variety}{(Mandatory) The mean of the variety}

\item{mu_check}{(Optional) The mean value of checks, default mu_check = 1.68 * sqrt(sigma_variety)}

\item{cov_fun}{(Optional) The var-cov function ('exp' or 'gau'), default is 'exp', exponential}

\item{ranges}{(Optional) The range parameter of spatial distribution, default sqrt(2)}

\item{simulation}{(Optional) The number of simulated data returned, default 3}

\item{nugget}{(Optional) The nugget parameter in spatial simulation, default 0}

\item{mu_floor}{(Optional) The mean of the spatial floor, default 0}

\item{p_rep_check}{The density of checks in the p rep design, default 0.05}
}
\description{
The function simulates spatial data by given parameters
}
\examples{
temp.1 = iso_simulation_by_heriability(20, 20, density.choice=c(0.05)
			, density.layout=c('diagSet', 'random')
			, h2=0.5, sigma_env=100, mu_variety=300)
temp.2 = iso_simulation_by_heriability(20, 20, density.choice=c(0.05)
			, density.layout=c('diagSet', 'random')
			, h2=0.5, sigma_env=100, mu_variety=300)
}
