% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Detrend.R
\name{Detrend}
\alias{Detrend}
\title{Auxiliary function for removing trends and mean from observation vector or ensemble matrix.}
\usage{
Detrend(x, demean = TRUE)
}
\arguments{
\item{x}{A vector, matrix, or data.frame.}

\item{demean}{logical; if true, the total mean is removed from x}
}
\value{
The function returns an object of the same dimensions as the argument `x`, but with its linear trend and (possibly) its mean removed.
}
\description{
Detrend fits a linear function to a time-series of observations or to the time-series of ensemble means of an ensemble matrix. The linear trend is removed, and if option demean is true, the total mean is removed as well.
}
\examples{
 data(eurotempforecast)
 Detrend(ens)
 Detrend(obs, demean=FALSE)
}

