% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{tsne}
\alias{tsne}
\title{tsne: A tsne function for similarity matrices or ordinary data}
\usage{
tsne(mydata, labels = FALSE, perplex = 15, seed = FALSE,
  axistextsize = 18, legendtextsize = 18, dotsize = 3,
  similarity = TRUE)
}
\arguments{
\item{mydata}{Data frame or matrix: kernel matrix or data frame with samples as columns, features as rows}

\item{labels}{Factor: to label the plot with colours}

\item{perplex}{Numerical value: this is the perplexity parameter for tsne, it usually requires adjusting for each dataset}

\item{seed}{Numerical value: to repeat the results exactly, setting seed is required}

\item{axistextsize}{Numerical value: axis text size}

\item{legendtextsize}{Numerical value: legend text size}

\item{dotsize}{Numerical value: dot size}

\item{similarity}{Logical flag: whether input is similarity matrix or not}
}
\value{
A tsne plot object
}
\description{
tsne: A tsne function for similarity matrices or ordinary data
}
\examples{
ex_tsne <- tsne(blobs[,1:50],perplex=15,similarity=FALSE)
}
