% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submod_ctree.R
\name{predict.submod_ctree}
\alias{predict.submod_ctree}
\title{Predict submod: CTREE}
\usage{
\method{predict}{submod_ctree}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{Trained ctree model.}

\item{newdata}{Data-set to make predictions at (Default=NULL, predictions correspond
to training data).}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Identified subgroups with subgroup-specific predictions of E(Y|X) or PLE(X).
\itemize{
  \item Subgrps - Identified subgroups
  \item pred - Predictions, E(Y|X) or PLE(X) by subgroup.
}
}
\description{
Predict subgroups and obtain subgroup-specific estimates, E(Y|X) or PLE(X), for a
trained ctree model (depends on if outcome_PLE argument)
}
\examples{
library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

res_ctree1 = submod_ctree(Y, A, X, Xtest=X)
# Predict subgroups / estimates #
out = predict(res_ctree1, newdata=X)

}
