% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/13-f-alt-plt-dis-msr.r
\name{plot_dissimilarity_alternative}
\alias{plot_dissimilarity_alternative}
\title{An alternative plot for displaying dissimilarity distances of subgroups}
\usage{
plot_dissimilarity_alternative(
  dat,
  covari.sel,
  mode,
  range.ds = c(0, 1),
  font.size = c(1.3, 1, 1),
  title = NULL,
  lab.y = NULL
)
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of covariates}

\item{mode}{a value specifying the type of display; either 1 or 2.}

\item{range.ds}{a vector specifying the range of the dissimilarity distance}

\item{font.size}{a vector specifying the size of labels and text; the first element is for the title; the second is for the x-axis label; the third
is for the labels of baseline subgroups; the fourth is for the remaining subgroup labels (except for the baseline subgroup).}

\item{title}{a string specifying the main titles.}

\item{lab.y}{a string specifying the y-axis label.}
}
\description{
this function produces a plot for displaying dissimilarity distances of pairwise subgroups, where dissmiliarity distance is
defined by 1 - |intersect(A, B)|/|A|, for any sets A and B and A is the baseline set. The letters represent subgroups defined
by the categories of the selected covariates.The vertical axis represents dissimilarity distance. Each column has a letter
standing for a subgroup as the baseline for calculating dissimilarity distances. There are two modes of display - one is that
subgroup letters are located at the exact dissimilarity distance with different types and colours of points; the other is
that lines connected to all the points.  The colour of lines or points indicates whether subgroups are from the same
covariate or not. The number of types shows how many categories (from the same covariate) are considered as subgroups. The
range of dissimilarity distances can be adjusted.
}
\examples{
data(prca)
dat <- prca
## 1. dissimilarity alternative plot ----------------------------------------
plot_dissimilarity_alternative(dat = dat,
                               covari.sel = c(4,5,6),
                               mode = 2,
                               range.ds = c(0,1),
                               font.size = c(1, 1, 0.7),
                               title = NULL,
                               lab.y = "Similarity distance")

}
