% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prim.R
\name{one.dropping.prog}
\alias{one.dropping.prog}
\title{Perform dropping one time in prognostic case.}
\usage{
one.dropping.prog(d.inside, d.outside, trace.inside.condition, yvar, censorvar,
  g.str, l.str, type, des.res)
}
\arguments{
\item{d.inside}{the dataset for subjects in consideration after pasting.}

\item{d.outside}{the dataset for subjects outside consideration after pasting.}

\item{trace.inside.condition}{list of signature rules used for d.inside.}

\item{yvar}{the name for response variable.}

\item{censorvar}{the name for censoring (1: event; 0: censor), default = NULL.}

\item{g.str}{">=".}

\item{l.str}{"<=".}

\item{type}{type of response variable: "c" continuous (default); "s" survival; "b" binary.}

\item{des.res}{the desired response. "larger": prefer larger response (default) "smaller": prefer smaller response.}
}
\value{
a data frame enlisting the signature rules (after dropping) ordered by main effect p-values in each group defined by the rules.
}
\description{
Perform dropping one time in prognostic case.
}
