% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prim.R
\name{one.peeling}
\alias{one.peeling}
\title{Perform peeling one time in predictive case.}
\usage{
one.peeling(d.inside, d.outside, xvars, alpha, min.size.inside, yvar, censorvar,
  trtvar, g.str, l.str, type, des.res)
}
\arguments{
\item{d.inside}{the dataset for subjects in consideration.}

\item{d.outside}{the dataset for subjects outside consideration.}

\item{xvars}{the vector of variable names for predictors (covariates).}

\item{alpha}{a parameter controlling the number of patients in consideration}

\item{min.size.inside}{desired number of subjects in signature positive group size for a given cutoff.}

\item{yvar}{the name of response variable.}

\item{censorvar}{the name of censoring variable (1: event; 0: censor), default = NULL).}

\item{trtvar}{0-1 coded vector for treatment variable.}

\item{g.str}{">=".}

\item{l.str}{"<=".}

\item{type}{type of response variable: "c" continuous (default); "s" survival; "b" binary.}

\item{des.res}{the desired response. "larger": prefer larger response (default) "smaller": prefer smaller response.}
}
\value{
a data frame enlisting the signature rules (after peeling) ordered by treatment p-values in each group defined by the rules
}
\description{
Perform peeling one time in predictive case.
}
