% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Toeplitz.R
\docType{class}
\name{Toeplitz-class}
\alias{Toeplitz-class}
\alias{.Toeplitz}
\alias{setAcf}
\alias{getAcf}
\alias{traceT2}
\alias{traceT4}
\alias{show.Toeplitz}
\alias{\%*\%}
\alias{determinant}
\alias{solve}
\alias{\%*\%,ANY,Toeplitz-method}
\alias{\%*\%,Toeplitz,ANY-method}
\alias{determinant,Toeplitz-method}
\alias{dim,Toeplitz-method}
\alias{ncol,Toeplitz-method}
\alias{nrow,Toeplitz-method}
\alias{show,Toeplitz-method}
\alias{solve,Toeplitz-method}
\alias{Toeplitz}
\title{Constructor and methods for Toeplitz matrix objects.}
\usage{
Toeplitz(n, acf)
}
\arguments{
\item{n}{Size of the Toeplitz matrix.}

\item{acf}{Autocorrelation vector of Toeplitz matrix.}
}
\value{
A \code{Toeplitz} object.
}
\description{
The \code{Toeplitz} class contains efficient methods for linear algebra with symmetric positive definite (i.e., variance) Toeplitz matrices.
}
\details{
It is assumed that the autocorrelation of the \code{Toeplitz} object defines a valid (i.e., positive definite) variance matrix.  The multiplication algorithms still work when this is not the case but the other algorithms do not (return values typically contain \code{NaN}s).
}

\section{Methods}{

If \code{Toep} is a \code{Toeplitz} object with first row/column given by \code{acf}, then:
\describe{
\item{\code{Toep$setAcf(acf)}}{Sets the autocorrelation of the matrix.}
\item{\code{Toep$getAcf()}}{Gets the autocorrelation of the matrix.}
\item{\code{nrow(Toep)}, \code{ncol(Toep)}, \code{dim(Toep)}}{Selected dimension(s) of the matrix.}
\item{\code{Toep \%*\% X}, \code{X \%*\% Toep}}{Toeplitz-Matrix and Matrix-Toeplitz multiplication.  Also works if \code{X} is a vector.}
\item{\code{solve(Toep, X)}, \code{solve(Toep)}}{Solves Toeplitz systems of equations.  When second argument is missing, returns the inverse of the Toeplitz matrix.}
\item{\code{determinant(Toep)}}{Log-determinant of the Toeplitz matrix, i.e., same thing as \code{log(det(toeplitz(acf)))}.}
\item{\code{Toep$traceT2(acf2)}}{If \code{T1 == toeplitz(acf)} and \code{T2 == toeplitz(acf2)}, computes the trace of \code{solve(T1, T2)}.  This is used in the computation of the gradient of Gaussian likelihoods with Toeplitz variance matrix.}
\item{\code{Toep$traceT4(acf2, acf3)}}{If \code{T1 == toeplitz(acf)}, \code{T2 == toeplitz(acf2)}, and \code{T3 == toeplitz(acf3)}, computes the trace of \code{solve(T1, T2) \%*\% solve(T1, T3)}.  This is used in the computation of the Hessian of Gaussian likelihoods with Toeplitz variance matrix.}
}
}

\examples{
# construction
acf <- exp(-(1:5))
Toep <- Toeplitz(acf = acf)
# alternatively, can allocate space first
Toep <- Toeplitz(n = length(acf))
Toep$setAcf(acf = acf)

dim(Toep) # == c(nrow(Toep), ncol(Toep))
Toep # show method
Toep$getAcf() # extract the acf

# linear algebra
X <- matrix(rnorm(10), 5, 2)
Toep \%*\% X
t(X) \%*\% Toep
solve(Toep, X)
determinant(Toep) # log-determinant
}
