% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model_SurvSurv.R
\name{twostep_SurvSurv}
\alias{twostep_SurvSurv}
\title{Fit survival-survival copula submodel with two-step estimator}
\usage{
twostep_SurvSurv(
  X,
  delta_X,
  Y,
  delta_Y,
  copula_family,
  n_knots,
  method = "BFGS"
)
}
\arguments{
\item{X}{(numeric) Possibly right-censored time-to-surrogate event}

\item{delta_X}{(integer) Surrogate event indicator:
\itemize{
\item \code{1L} if surrogate event ocurred.
\item \code{0L} if censored.
}}

\item{Y}{(numeric) Possibly right-censored time-to-true endpoint event}

\item{delta_Y}{(integer) True endpoint event indicator:
\itemize{
\item \code{1L} if true endpoint event ocurred.
\item \code{0L} if censored.
}}

\item{copula_family}{Copula family, one of the following:
\itemize{
\item \code{"clayton"}
\item \code{"frank"}
\item \code{"gumbel"}
\item \code{"gaussian"}

The parameterization of the respective copula families can be found in the
help files of the dedicated functions named \code{copula_loglik_copula_scale()}.
}}

\item{n_knots}{Number of internal knots for the Royston-Parmar survival model.}

\item{method}{Optimization algorithm for maximizing the objective function.
For all options, see \code{?maxLik::maxLik}. Defaults to \code{"BFGRS"}.}
}
\value{
A list with three elements:
\itemize{
\item ml_fit: object of class \code{maxLik::maxLik} that contains the estimated copula
model.
\item marginal_S_dist: object of class \code{fitdistrplus::fitdist} that represents the
marginal surrogate distribution.
\item copula_family: string that indicates the copula family
}
}
\description{
The \code{twostep_SurvSurv()} function fits the copula (sub)model for a
time-to-event surrogate and true endpoint with a two-step estimator. In the
first step, the marginal distribution parameters are estimated through
maximum likelihood. In the second step, the copula parameter is estimate
while holding the marginal distribution parameters fixed.
}
