% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dcSVM.R
\name{dcSVM}
\alias{dcSVM}
\title{Divide-and-Conquer kernel SVM (DC-SVM)}
\usage{
dcSVM(x, y, k = 4, m, kernel = 3, max.levels, early = 0,
  final.training = FALSE, pre.scale = FALSE, seed = NULL,
  verbose = TRUE, valid.x = NULL, valid.y = NULL, valid.metric = NULL,
  cluster.method = "kmeans", cluster.fun = NULL, cluster.predict = NULL,
  ...)
}
\arguments{
\item{x}{the nxp training data matrix. Could be a matrix or a sparse matrix object.}

\item{y}{a response vector for prediction tasks with one value for each of the n rows of \code{x}.
For classification, the values correspond to class labels and can be a 1xn matrix,
a simple vector or a factor. For regression, the values correspond to the values to predict,
and can be a 1xn matrix or a simple vector.}

\item{k}{the number of sub-problems divided}

\item{m}{the number of sample for kernel kmeans}

\item{kernel}{the kernel type: 1 for linear, 2 for polynomial, 3 for gaussian}

\item{max.levels}{the maximum number of level}

\item{early}{whether use early prediction}

\item{final.training}{whether train the svm over the entire data again. usually not needed.}

\item{pre.scale}{either a logical value indicating whether to scale the data or not, or an integer vector specifying the columns.
We don't scale data in SVM seperately.}

\item{seed}{the random seed. Set it to \code{NULL} to randomize the model.}

\item{verbose}{a logical value indicating whether to print information of training.}

\item{valid.x}{the mxp validation data matrix.}

\item{valid.y}{if provided, it will be used to calculate the validation score with \code{valid.metric}}

\item{valid.metric}{the metric function for the validation result. By default it is the accuracy for classification.
Customized metric is acceptable.}

\item{cluster.method}{The clusterign algorithm to use. Possible choices are
\itemize{
    \item "kmeans" Algorithm from \code{stats::kmeans}
    \item "mlKmeans" Algorithm from \code{RcppMLPACK::mlKmeans}
    \item "kernkmeans" Algorithm from \code{kernlab::kkmeans}
}
If \code{cluster.fun} and \code{cluster.predict} are provided, \code{cluster.method} doesn't work anymore.}

\item{cluster.fun}{The function to train cluster labels for the data based on given number of centers.
Customized function is acceptable, as long as the resulting list contains two fields named as \code{cluster} and \code{centers}.}

\item{cluster.predict}{The function to predict cluster labels for the data based on trained object.
Customized function is acceptable, as long as the resulting list contains two fields named as \code{cluster} and \code{centers}.}

\item{...}{other parameters passed to \code{e1071::svm}}
}
\value{
\itemize{
   \item \code{svm} a list of svm models if using early prediction, or an svm object otherwise.
   \item \code{early} whether using the early prediction strategy or not
   \item \code{cluster.tree} a matrix containing clustering labels in each level
   \item \code{cluster.fun} the clustering training function
   \item \code{cluster.predict} the clustering predicting function
   \item \code{scale} a list containing scaling information
   \item \code{valid.pred} the validation prediction
   \item \code{valid.score} the validation score
   \item \code{valid.metric} the validation metric
   \item \code{time} a list object recording the time consumption for each steps.
}
}
\description{
Implementation of Divide-and-Conquer kernel SVM (DC-SVM) by Cho-Jui Hsieh, Si Si, and Inderjit S. Dhillon
}
\examples{
data(svmguide1)
svmguide1.t = as.matrix(svmguide1[[2]])
svmguide1 = as.matrix(svmguide1[[1]])
dcsvm.model = dcSVM(x = svmguide1[,-1], y = svmguide1[,1],
                    k = 4, max.levels = 4, seed = 0, cost = 32, gamma = 2,
                    kernel = 3,early = 0, m = 800,
                    valid.x = svmguide1.t[,-1], valid.y = svmguide1.t[,1])
preds = dcsvm.model$valid.pred
table(preds, svmguide1.t[,1])
dcsvm.model$valid.score
}

