\name{tepPLSCA}
\alias{tepPLSCA}
\encoding{UTF-8}
\title{
Partial Least Squares-Correspondence Analysis
}
\description{
Partial Least Squares-Correspondence Analysis (PLSCA) via TExPosition.
}
\usage{
tepPLSCA(DATA1, DATA2, make_data1_nominal = FALSE, make_data2_nominal = FALSE, 
DESIGN = NULL, make_design_nominal = TRUE, 
weights1=NULL, weights2 = NULL, 
symmetric = TRUE, graphs = TRUE, k = 0)
}
\arguments{
  \item{DATA1}{Data matrix 1 (X), must be categorical (like MCA) or in disjunctive code see \code{make_data1_nominal}.}
  \item{DATA2}{Data matrix 2 (Y), must be categorical (like MCA) or in disjunctive code see \code{make_data2_nominal}.}  
  \item{make_data1_nominal}{a boolean. If TRUE (default), DATA1 is recoded as a dummy-coded matrix. If FALSE, DATA1 is a dummy-coded matrix.}
  \item{make_data2_nominal}{a boolean. If TRUE (default), DATA2 is recoded as a dummy-coded matrix. If FALSE, DATA2 is a dummy-coded matrix.}  
  \item{DESIGN}{a design matrix to indicate if rows belong to groups.}
  \item{make_design_nominal}{a boolean. If TRUE (default), DESIGN is a vector that indicates groups (and will be dummy-coded). If FALSE, DESIGN is a dummy-coded matrix.}
  \item{weights1}{a diagonal matrix or column-vector of weights for the columns of DATA1}
  \item{weights2}{a diagonal matrix or column-vector of weights for the columns of DATA2}  
  \item{symmetric}{a boolean. If TRUE (default) symmetric factor scores for rows.}
  \item{graphs}{a boolean. If TRUE (default), graphs and plots are provided (via \code{\link{tepGraphs}})}
  \item{k}{number of components to return.}
}
\value{
	See \code{\link{epCA}} (and also \code{\link{coreCA}}) for details on what is returned. In addition to the values returned:\cr
	\item{W1}{Weights for columns of DATA1, replaces \code{M} from \code{coreCA}.}
	\item{W2}{Weights for columns of DATA2, replaces \code{W} from \code{coreCA}.}
	\item{lx}{latent variables from DATA1 computed for observations}
	\item{ly}{latent variables from DATA2 computed for observations}	
}
\details{
	This implementation of Partial Least Squares is for two categorical data sets (Beaton et al., 2013), and based on the PLS method proposed by Tucker (1958) and again by Bookstein (1994). 
}
\references{
	Tucker, L. R. (1958). An inter-battery method of factor analysis. \emph{Psychometrika}, \emph{23}(2), 111--136. \cr
	Bookstein, F., (1994). Partial least squares: a dose–response model for measurement in the behavioral and brain sciences. \emph{Psycoloquy} \emph{5} (23) \cr	
Abdi, H. (2007). Singular Value Decomposition (SVD) and Generalized Singular Value Decomposition (GSVD). In N.J. Salkind (Ed.): \emph{Encyclopedia of Measurement and Statistics}.Thousand Oaks (CA): Sage. pp. 907-912.\cr
	Krishnan, A., Williams, L. J., McIntosh, A. R., & Abdi, H. (2011). Partial Least Squares (PLS) methods for neuroimaging: A tutorial and review. \emph{NeuroImage}, \emph{56}(\bold{2}), 455 -- 475.\cr
Beaton, D., Filbey, F., & Abdi H. (in press, 2013). Integrating partial least squares correlation and correspondence analysis for nominal data. In Abdi, H., Chin, W., Esposito Vinzi, V., Russolillo, G., & Trinchera, L. (Eds.), New Perspectives in Partial Least Squares and Related Methods. New York: Springer Verlag.
}
\author{
Derek Beaton, Hervé Abdi
}

\seealso{
\code{\link{coreCA}}, \code{\link{epCA}}, \code{\link{epMCA}}, \code{\link{tepDICA}} \cr
}
\examples{
	data(snps.druguse)
	plsca.res <- tepPLSCA(snps.druguse$DATA1,snps.druguse$DATA2,
			make_data1_nominal=TRUE,make_data2_nominal=TRUE)
}
\keyword{ multivariate }
