% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GulPC_TFM.R
\name{GulPC_TFM}
\alias{GulPC_TFM}
\title{Apply the GulPC method to the Truncated factor model}
\usage{
GulPC_TFM(data, m, A, D)
}
\arguments{
\item{data}{A matrix of input data.}

\item{m}{The number of principal components.}

\item{A}{The true factor loadings matrix.}

\item{D}{The true uniquenesses matrix.}
}
\value{
A list containing:
\item{AU1}{The first layer loading matrix.}
\item{AU2}{The second layer loading matrix.}
\item{DU3}{The estimated specific variance matrix.}
\item{MSESigmaD}{Mean squared error for uniquenesses.}
\item{LSigmaD}{Loss metric for uniquenesses.}
}
\description{
This function performs General Unilateral Loading Principal Component (GulPC) analysis on a given data set. It calculates the estimated values for the first layer and second layer loadings, specific variances, and the mean squared errors.
}
\examples{
\dontrun{
library(SOPC)
library(relliptical)
library(MASS)
results <- GulPC_TFM(data, m, A, D)
print(results)}
}
