% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.soft.R
\name{p.soft}
\alias{p.soft}
\title{CDF of soft-thresholding Fisher's p-value combination statistic under the null hypothesis.}
\usage{
p.soft(q, n, tau1)
}
\arguments{
\item{q}{- quantile, could be a vector.}

\item{n}{- dimension parameter, i.e. the number of p-values to be combined.}

\item{tau1}{- truncation parameter=normalization parameter. tau1 > 0.}
}
\value{
The left-tail probability of the null distribution of soft-thresholding Fisher's p-value combination statistic at the given quantile.
}
\description{
CDF of soft-thresholding Fisher's p-value combination statistic under the null hypothesis.
}
\examples{
pval <- runif(100)
softstat <- stat.soft(p=pval, tau1=0.05)
p.soft(q=softstat, n=100, tau1=0.05)
}
\references{
1. Hong Zhang and Zheyang Wu. "Optimal Thresholding of Fisher's P-value Combination
Tests for Signal Detection", submitted.
}
\seealso{
\code{\link{stat.soft}} for the definition of the statistic.
}
