% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.tfisher.R
\name{power.tfisher}
\alias{power.tfisher}
\title{Statistical power of thresholding Fisher's p-value combination test under Gaussian mixture model.}
\usage{
power.tfisher(alpha, n, tau1, tau2, eps = 0, mu = 0)
}
\arguments{
\item{alpha}{- type-I error rate.}

\item{n}{- dimension parameter, i.e. the number of input p-values.}

\item{tau1}{- truncation parameter. 0 < tau1 <= 1.}

\item{tau2}{- normalization parameter. tau2 >= tau1.}

\item{eps}{- mixing parameter of the Gaussian mixture.}

\item{mu}{- mean of non standard Gaussian model.}
}
\value{
Power of the thresholding Fisher's p-value combination test.
}
\description{
Statistical power of thresholding Fisher's p-value combination test under Gaussian mixture model.
}
\details{
We consider the following hypothesis test,
\deqn{H_0: X_i\sim F_0, H_a: X_i\sim (1-\epsilon)F_0+\epsilon F_1}
, where \eqn{\epsilon} is the mixing parameter,
\eqn{F_0} is the standard normal CDF and \eqn{F = F_1} is the CDF of normal distribution with \eqn{\mu} defined by mu and \eqn{\sigma = 1}.
}
\examples{
alpha = 0.05
#If the alternative hypothesis Gaussian mixture with eps = 0.1 and mu = 1.2:#
power.tfisher(alpha, 100, 0.05, 0.25, eps = 0.1, mu = 1.2)
}
\references{
1. Hong Zhang and Zheyang Wu. "Optimal Thresholding of Fisher's P-value Combination
Tests for Signal Detection", submitted.
}
\seealso{
\code{\link{stat.tfisher}} for the definition of the statistic.
}
