% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_TL.SAR.R
\name{plot_TL.SAR}
\alias{plot_TL.SAR}
\title{plots MAAD results}
\usage{
plot_TL.SAR(sample.name, sample.position, fitting.parameters = list(fit.method
  = "LIN", fit.weighted = FALSE, fit.rDoses.min = NA, fit.rDoses.max = NA),
  eval.Tmin, eval.Tmax, temperatures, names, names.duplicated, doses, Lx, Tx,
  LxTx, Lx.plateau, Tx.plateau, LxTx.plateau, DP.Q.line, DP.Q.line.error,
  GC.Q.line, GC.Q.LxTx, GC.Q.LxTx.error, GC.Q.slope, Q.DP, Q.DP.error, Q.GC,
  Q.GC.error, TxTn, rejection.values, plotting.parameters = list(plot.Tmin =
  0, plot.Tmax = NA))
}
\arguments{
\item{sample.name}{\link{character} (\bold{required}): Sample name.}

\item{sample.position}{\link{integer} (\bold{required}): aliquot position.}

\item{fitting.parameters}{\link{list} (with default): list containing the fitting parameters. See details.}

\item{eval.Tmin}{\link{integer} (\bold{required}): Temperature (°C) of the lower boundary for the signal integration.}

\item{eval.Tmax}{\link{integer} (\bold{required}): Temperature (°C) of the upper boundary for the signal integration.}

\item{temperatures}{\link{numeric} (\bold{required}): temperature vector}

\item{names}{\link{character} (\bold{required}): Name vector for the regenerative curves.}

\item{names.duplicated}{\link{character} (\bold{required}): Name vector for the duplicated doses.}

\item{doses}{\link{numeric} (\bold{required}): Dose vector for the regenerative curves.}

\item{Lx}{\link{numeric} (\bold{required}): Lx matrix for the regenerative curves.}

\item{Tx}{\link{numeric} (\bold{required}): Tx matrix for the regenerative curves.}

\item{LxTx}{\link{numeric} (\bold{required}): Lx/Tx matrix for the regenerative curves.}

\item{Lx.plateau}{\link{numeric} (\bold{required}): Ln/Lx matrix for the regenerative curves.}

\item{Tx.plateau}{\link{numeric} (\bold{required}): Tn/Tx matrix for the regenerative curves.}

\item{LxTx.plateau}{\link{numeric} (\bold{required}): (Ln/Tn)/(Lx/Tx) matrix for the regenerative curves.}

\item{DP.Q.line}{\link{numeric} (\bold{required}): Vector containing the estimation of Q for each T° step.}

\item{DP.Q.line.error}{\link{numeric} (\bold{required}): Vector containing the uncertainty on the estimation of Q for each T° step.}

\item{GC.Q.line}{\link{numeric} (\bold{required}): growth curve for Q}

\item{GC.Q.LxTx}{\link{numeric} (\bold{required}): Lx/Tx vector used for Q estimation using the growth curve approach.}

\item{GC.Q.LxTx.error}{\link{numeric} (\bold{required}): Error on the Lx/tx vector used for Q estimation using the growth curve approach.}

\item{GC.Q.slope}{\link{numeric} (\bold{required}): growth curve parameters for Q}

\item{Q.DP}{\link{numeric} (\bold{required}): Q estimation using the dose plateau approach}

\item{Q.DP.error}{\link{numeric} (\bold{required}): Uncertainty on the Q estimation using the dose plateau approach}

\item{Q.GC}{\link{numeric} (\bold{required}): Q estimation using the growth curve approach}

\item{Q.GC.error}{\link{numeric} (\bold{required}): Uncertainty on the Q estimation using the growth curve approach}

\item{TxTn}{\link{numeric} (\bold{required}): average Tx/Tn value for the regenerative curves.}

\item{rejection.values}{\link{list} (\bold{required}): result of the rejection tests.}

\item{plotting.parameters}{\link{list} (with default): list containing the plotting parameters. See details.}
}
\description{
This function plots the results obtained by the analyse_TL.MAAD function.
}
\details{
\bold{Fitting parameters} \cr
The fitting parameters are:  \cr
\describe{
 \item{\code{method}}{
   \link{character}: Fitting method (\code{LIN}, \code{EXP}, \code{EXP+LIN} or \code{EXP+EXP}).}
 \item{\code{fit.weighted}}{
   \link{logical}: If the fitting is weighted or not.}
 \item{\code{fit.rDoses.min}}{
   \link{numeric}: Lower regenerative dose used for the fitting.}
 \item{\code{fit.rDoses.max}}{
   \link{numeric}: Higher regenerative dose used for the fitting.}
}
See also \link{calc_TL.SAR.fit}. \cr

\bold{Plotting parameters} \cr
The plotting parameters are:  \cr
\describe{
 \item{\code{plot.Tmin}}{
   \link{numeric}: Lower temperature plotted.} 
 \item{\code{plot.Tmax}}{
   \link{numeric}: Higher temperature plotted.}
 \item{\code{no.plot}}{
   \link{logical}: If \code{TRUE}, the results will not be plotted.}
}
See also \link{plot_TL.SAR}. \cr
}
\author{
David Strebler
}

