% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TMTI.R
\name{TMTI}
\alias{TMTI}
\title{Functions for computing the TMTI tests}
\usage{
TMTI(
  pvals,
  n = Inf,
  tau = NULL,
  K = NULL,
  gamma = NULL,
  log.p = TRUE,
  B = 1000,
  m_max = 100,
  ...
)
}
\arguments{
\item{pvals}{A vector of pvalues}

\item{n}{A positive number (or Inf) indicating which type of local minimum
to consider. Defaults to Infm, corresponding to the global minimum.}

\item{tau}{Number between 0 and 1 or NULL, describing the truncation level.}

\item{K}{Integer between >1 and m describing the truncation index.}

\item{gamma}{Function; function to be used as the gamma approximation. If NULL, then
the gamma function will be bootstrapped assuming independence. Defaults
to NULL}

\item{log.p}{Logical; indicating whether to compute Y's on log-scale.
Defaults to TRUE}

\item{B}{Numeric; number of bootstrap replicates to be used when estimating
the gamma function. If a gamma is supplied, this argument is ignored.
Defaults to 1e3.}

\item{m_max}{Integer; the highest number of test for which the analytical
computation of the TMTI CDF is used. When m is above m_max it will be
bootstrapped or user supplied instead.}

\item{...}{Additional parameters}
}
\value{
A p-value from the TMTI test
}
\description{
Functions for computing the TMTI tests
}
\examples{
## Simulate some p-values
## The first 10 are from false hypotheses, the next 10 are from true
pvals <- c (
    rbeta(10, 1, 20),  ## Mean value of .05
    runif(10)
)
TMTI(pvals)
}
