% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerTOSTpaired.R
\name{powerTOSTpaired}
\alias{powerTOSTpaired}
\title{Power analysis for TOST for dependent t-test (Cohen's dz).}
\usage{
powerTOSTpaired(alpha, statistical_power, N, low_eqbound_dz, high_eqbound_dz)
}
\arguments{
\item{alpha}{alpha used for the test (e.g., 0.05)}

\item{statistical_power}{desired power (e.g., 0.8)}

\item{N}{number of pairs (e.g., 96)}

\item{low_eqbound_dz}{lower equivalence bounds (e.g., -0.5) expressed in standardized mean difference (Cohen's dz)}

\item{high_eqbound_dz}{upper equivalence bounds (e.g., 0.5) expressed in standardized mean difference (Cohen's dz)}
}
\value{
Calculate either achieved power, equivalence bounds, or required N.
Returns a string summarizing the power analysis, and a numeric variable for number of observations, equivalence bounds, or power.
}
\description{
Power analysis for TOST for dependent t-test (Cohen's dz).
}
\section{References}{

Chow, S.-C., Wang, H., & Shao, J. (2007). Sample Size Calculations in Clinical Research, Second Edition - CRC Press Book. Formula 3.1.9
}

\examples{
## Sample size for alpha = 0.05, 80\% power, equivalence bounds of
## Cohen's dz = -0.3 and Cohen's d = 0.3, and assuming true effect = 0
powerTOSTpaired(alpha=0.05,statistical_power=0.8,low_eqbound_dz=-0.3,high_eqbound_dz=0.3)

## Sample size for alpha = 0.05, N = 96 pairs, equivalence bounds of
## Cohen's dz = -0.3 and Cohen's d = 0.3, and assuming true effect = 0
powerTOSTpaired(alpha=0.05,N=96,low_eqbound_dz=-0.3,high_eqbound_dz=0.3)

## Equivalence bounds for alpha = 0.05, N = 96 pairs, statistical power of
## 0.8, and assuming true effect = 0
powerTOSTpaired(alpha=0.05,N=96,statistical_power=0.8)
}
