% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_functions.R
\name{ts_decompose}
\alias{ts_decompose}
\title{Visualization of the Decompose of a Time Series Object}
\usage{
ts_decompose(ts.obj, type = "additive", showline = TRUE)
}
\arguments{
\item{ts.obj}{a univariate time series object of a class "ts", "zoo" or "xts"}

\item{type}{Set the type of the seasonal component, can be set to either "additive",  "multiplicative" or "both" to compare between the first two options (default set to “additive”)}

\item{showline}{Logic, add a separation line between each of the plot components (default set to TRUE)}
}
\description{
Interactive visualization the trend, seasonal and random components of a time series based on the decompose function from the stats package.
}
\examples{
# Defualt decompose plot
ts_decompose(AirPassengers)

# Remove the sepration lines between the plot components
ts_decompose(AirPassengers, showline = FALSE)

# Plot side by side a decompose of additive and multiplicative series
ts_decompose(AirPassengers, type = "both")

}
