% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{nsur2}
\alias{nsur2}
\title{Component biomass functions}
\usage{
nsur2(spp, dbh, ht)
}
\arguments{
\item{spp}{vector of species code for biomass component function of interval
[1;8]; see \code{\link{BaMap}} for mapping of species model codes}

\item{dbh}{vector of diameter in breast height; in centimeter}

\item{ht}{vector of tree heights, in meter}
}
\value{
a numeric matrix holding component biomass
}
\description{
evaluation of the component biomass functions fit by nonlinear seemingly
unrelated regression (NSUR) to estimate absolute or relative component mass
}
\details{
simple function from Vonderach et al. (2018) to calculate component
biomass; species mapping as in \code{TapeS::BaMap(, type=7)}
}
\examples{
nsur2(spp = c(1, 6),
      dbh = c(30, 30),
      ht = c(25, 27))
}
\references{
Vonderach, C., G. Kändler and C. F. Dormann (2018).
"Consistent set of additive biomass functions for eight tree species in
Germany fit by nonlinear seemingly unrelated regression."
Annals of Forest Science 75(2): 49.
\doi{10.1007/s13595-018-0728-4}
}
