% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tprVolume.r
\name{tprVolume}
\alias{tprVolume}
\alias{tprVolume,tprTrees-method}
\title{Functions to calculate stem volume from taper curve}
\usage{
tprVolume(
  obj,
  AB = NULL,
  iAB = NULL,
  bark = NULL,
  interval = "none",
  mono = TRUE,
  Rfn = NULL
)

\S4method{tprVolume}{tprTrees}(
  obj,
  AB = list(A = 0, B = 7, sl = 2),
  iAB = c("h", "dob"),
  bark = TRUE,
  interval = "none",
  mono = TRUE,
  Rfn = NULL
)
}
\arguments{
\item{obj}{object of class 'tprTrees'}

\item{AB}{list with heights or diameters A and B of section for which volume
over or under bark should be calculated. Additionally, add in \code{sl} for
the segment length over which the integral should be calculated. See details.}

\item{iAB}{character indicating how to interpret given A and B values. Either
"H" (the default), "Dob" (diameter over bark) or "Dub" (diameter under bark).
Could be of length one or two, depending on whether A and B are both height
or diameter variables or not. See examples.}

\item{bark}{should volume be returned including (\code{TRUE}) or excluding
bark (\code{FALSE})?}

\item{interval}{character to indicate whether and which type of interval is
required; one of \code{none}, \code{confidence} or \code{prediction}.}

\item{mono}{logical, defaults to true. If calibrated taper curve is
non-monotonic at stem base, a support diameter is added.}

\item{Rfn}{Rfn setting for residuals error matrix, defaults to
\code{list(fn="sig2")}, see \code{\link[TapeR]{resVar}}.}
}
\value{
if \code{interval='none'} a vector else a matrix.
}
\description{
Function calculates stem volume from taper curve for given
trees, depending definition of segment and on bark indicator. It is possible
to request confidence or prediction intervals.
}
\details{
The function returns total solid wood w/ bark (i.e. from H=0 to
D=7cm) by default. Using \code{AB}, one can specify lower \code{A} and upper
\code{B} end of segments for which volume is required, w/ or w/o bark.

\code{iAB} can be a vector of length two, indicating how to interpret A and
B. Hence, one can calculate volume between a given height and a given
diameter, either over or under bark. If of length one, it is assumed that the
indicator applies to both A and B.

Defining interval \code{'confidence'} or \code{'prediction'} returns
lower (lwr) and upper (upr) interval bounds on confidence level
\eqn{\alpha} = \code{qt(0.025, ...)}. NB: The volume confidence bounds only
incorporate the uncertainty of diameter estimation at a pre-fixed position
(e.g. H=1.3m). If the position is given as diameter (e.g. \code{iAB="Dob"}),
the absolute height position is calculated using the *estimated* diameter,
hence, the uncertainty of the estimated absolute height is not (yet)
included. Neither is the uncertainty of the models for bark reduction.

In contrast to the underlying R-package TapeR, which uses
\code{\link[TapeR]{E_VOL_AB_HmDm_HT.f}} for volume calculation, this function
calculates volume based on stem-section (default: 2m, see parameter
\code{AB}). Additionally, with that approach, bark reduction is easily
possible.
}
\section{Methods (by class)}{
\itemize{
\item \code{tprVolume(tprTrees)}: method for class 'tprTrees'

}}
\examples{
obj <- simTrees() # default is: simulate 10 Norway spruce with mean dbh of 40
A <- 1
B <- 10
tprVolume(obj) # default is: coarse wood volume w/ bark
tprVolume(obj, AB = list(A=A, B=B, sl=2), iAB = "H", bark=FALSE)
tprVolume(obj, AB = list(A=A, B=B, sl=0.01), iAB = "H", bark=FALSE)
tprVolume(obj, AB = list(A=A, B=B, sl=0.01), iAB = "H", bark=TRUE)

## compare against integrated taper curve volume via package TapeR
## TapeR integrates over the taper curve, while TapeS uses segments of length 'sl'
SKP <- TapeS:::SKPar
TapeR::E_VOL_AB_HmDm_HT.f(Hm=obj@Hm[[1]], Dm = obj@Dm[[1]], iDH = "H",
                          mHt = obj@Ht[1], sHt = 0, A = A, B = B,
                          par.lme=SKP[[1]])$E_VOL

## returning intervals
tprVolume(obj, interval="none")
tprVolume(obj, interval="confidence")
tprVolume(obj, interval="prediction")
tprVolume(obj, interval="prediction", bark=FALSE)
tprVolume(obj, interval="prediction", AB=list(A=0.1, B=5.1, sl=0.1), iAB="H")
}
\seealso{
\code{\link[TapeR]{E_DHx_HmDm_HT.f}} for the underlying diameter
calculation.
}
