% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{pMixHoeffInd}
\alias{pMixHoeffInd}
\alias{dMixHoeffInd}
\alias{rMixHoeffInd}
\alias{qMixHoeffInd}
\title{Null asymptotic distribution of t* in the mixed case}
\usage{
pMixHoeffInd(x, probs, lower.tail = TRUE, error = 10^-6)

dMixHoeffInd(x, probs, error = 10^-3)

rMixHoeffInd(n, probs, error = 10^-8)

qMixHoeffInd(p, probs, error = 10^-4)
}
\arguments{
\item{x}{the value (or vector of values) at which to evaluate the function.}

\item{probs}{a vector of probabilities corresponding to the (ordered)
support the marginally discrete random variable. That is, if the
marginally discrete distribution has support \eqn{u_1,...,u_n}
then the ith entry of probs should be the probability of seeing
\eqn{u_i}.}

\item{lower.tail}{a logical value, if TRUE (default), probabilities are
\eqn{P(X\leq x)} otherwise \eqn{P(X>x)}.}

\item{error}{a tolerated error in the result. This should be considered as a
guide rather than an exact upper bound to the amount of error.}

\item{n}{the number of observations to return.}

\item{p}{the probability (or vector of probabilities) for which to get the
quantile.}
}
\value{
dMixHoeffInd gives the density, pMixHoeffInd gives the distribution
        function, qMixHoeffInd gives the quantile function, and
        rMixHoeffInd generates random samples.
}
\description{
Density, distribution function, quantile function and random generation for
the asymptotic null distribution of t* in the mixed case. That is, in the
case that t* is generated a sample from an independent bivariate distribution
where one coordinate is marginally discrete and the other marginally
continuous.
}
