% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_bibliography.R
\name{validate_bibliography}
\alias{validate_bibliography}
\title{Validate bibliography according to Grattan style}
\usage{
validate_bibliography(path = ".", file = NULL, .report_error)
}
\arguments{
\item{path}{Containing the bib file.}

\item{file}{The bib file if specified.}

\item{.report_error}{How errors should be reported.}
}
\value{
\code{NULL} if bibliography validated.
}
\description{
Validate bibliography according to Grattan style
}
\details{
This is a highly fastidious test of the bibliography. Useful for collaboration to ensure consistent style.
}
\examples{
\dontrun{
bib_temp <- tempfile(fileext = ".bib")
url_bib <- 
  paste0("https://raw.githubusercontent.com/HughParsonage/",
         "grattex/e6cab97145d38890e44e83d122e995e3b8936fc6",
         "/bib/Grattan-Master-Bibliography.bib")

download.file(url_bib, destfile = bib_temp)
validate_bibliography(file = bib_temp)

bib_temp <- tempfile(fileext = ".bib")
url_bib <- 
  paste0("https://raw.githubusercontent.com/HughParsonage/",
         "grattex/8f7f52a28789d12a363ceb30cea3b41f590ae58a",
         "/bib/Grattan-Master-Bibliography.bib")
download.file(url_bib, destfile = bib_temp)
validate_bibliography(file = bib_temp)
}

}
