\name{project.Map}
\alias{project.Map}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Apply projections to Map objects (from maptools package) }
\description{
  Apply the \code{mapproject} function from the \code{mapproj} library
  to Map objects from the \code{maptools} library.
}
\usage{
project.Map(Map, projection = "", parameters = NULL, orientation = c(90, 0, 0))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{Map}{ A \code{Map} object. }
  \item{projection}{ See \code{mapproject} }
  \item{parameters}{ See \code{mapproject} }
  \item{orientation}{ See \code{mapproject}  }
}
\details{
  This function takes a \code{Map} object and applies \code{mapproject}
  from the \code{mapproject} library to it.
}
\value{
  An object of class \code{Map} with the coordinates transformed.
}
%\references{ ~put references to the literature/web site here ~ }
\author{ Greg Snow \email{greg.snow@ihc.com} }
\note{ This is beta level software and will someday be superceded by the
\code{spproj} package.}



\seealso{ \code{mapproject} from the mapproj library. }
\examples{
\dontrun{

library(mapproj)
# assumes that the time zone shape files have been downloaded
# from: http://openmap.bbn.com/data/shape/timezone/

tz <- read.shape('WRLDTZA')
plot(Map2poly(project.Map(tz,'bonne',param=45)))

plot(Map2poly(project.Map(tz,'bonne',param=45)),
  col=rainbow(48)[tz$att.data$OFFSET])

plot(Map2poly(project.Map(tz,'albers',param=c(30,40))))
}
}
\keyword{ manip }% at least one, from doc/KEYWORDS
\keyword{ spatial }% __ONLY ONE__ keyword per line
