% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma.R
\name{fit.Gamma}
\alias{fit.Gamma}
\title{Gamma Distribution Parameter Estimation}
\usage{
fit.Gamma(
  time,
  status,
  sig = 0.05,
  tau = NULL,
  init = NULL,
  eps = 1e-06,
  maxit = 10,
  report = FALSE
)
}
\arguments{
\item{time}{Numeric observation times.}

\item{status}{Status indicator, coded as 1 if an event was observed, 0 if censored.}

\item{sig}{Significance level, for CIs.}

\item{tau}{Optional truncation times for calculating RMSTs.}

\item{init}{Vector of initial values for shape \eqn{\alpha} and
rate \eqn{\lambda} parameters, respectively.}

\item{eps}{Tolerance for Newton-Raphson iterations.}

\item{maxit}{Maximum number of NR iterations.}

\item{report}{Report fitting progress?}
}
\value{
An object of class \code{fit} containing the following:
\describe{
 \item{Parameters}{The estimated shape \eqn{\alpha} and rate \eqn{\lambda}.}
 \item{Information}{The observed information matrix.}
 \item{Outcome}{The fitted mean, median, and variance.}
 \item{RMST}{The estimated RMSTs, if tau was specified.}
}
}
\description{
Estimates parameters for gamma event times subject to non-informative
right censoring. The gamma distribution is parameterized in terms
of the shape \eqn{\alpha} and rate \eqn{\lambda}:
\deqn{f(t) = \frac{\lambda}{\Gamma(\alpha)}(\lambda t)^{\alpha-1}e^{-\lambda t}, t>0}
}
\examples{
# Generate Gamma data with 20\% censoring. 
data = genData(n=1e3,dist="gamma",theta=c(2,2),p=0.2);
# Estimate
fit = fitParaSurv(time=data$time,status=data$status,dist="gamma");
}
\seealso{
\itemize{
  \item{Fitting function for parametric survival distributions \code{\link{fitParaSurv}}}
}
}
