% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_functions.R
\docType{methods}
\name{calcEscore}
\alias{calcEscore}
\alias{calcEscore,item_1PL,numeric-method}
\alias{calcEscore,item_2PL,numeric-method}
\alias{calcEscore,item_3PL,numeric-method}
\alias{calcEscore,item_PC,numeric-method}
\alias{calcEscore,item_GPC,numeric-method}
\alias{calcEscore,item_GR,numeric-method}
\alias{calcEscore,item_pool,numeric-method}
\alias{calcEscore,pool_cluster,numeric-method}
\title{Calculate expected scores}
\usage{
calcEscore(object, theta)

\S4method{calcEscore}{item_1PL,numeric}(object, theta)

\S4method{calcEscore}{item_2PL,numeric}(object, theta)

\S4method{calcEscore}{item_3PL,numeric}(object, theta)

\S4method{calcEscore}{item_PC,numeric}(object, theta)

\S4method{calcEscore}{item_GPC,numeric}(object, theta)

\S4method{calcEscore}{item_GR,numeric}(object, theta)

\S4method{calcEscore}{item_pool,numeric}(object, theta)

\S4method{calcEscore}{pool_cluster,numeric}(object, theta)
}
\arguments{
\item{object}{An instance of an item class.}

\item{theta}{A vector of theta values.}
}
\value{
A vector of expected scores of length nq (the number of values on theta grid).
}
\description{
An S4 generic and its methods to calculate expected scores given a vector of thetas for different item classes.
}
\examples{
item_1     <- new("item_1PL", difficulty = 0.5)
ICC_item_1 <- calcEscore(item_1, seq(-3, 3, 1))
item_2     <- new("item_2PL", slope = 1.0, difficulty = 0.5)
ICC_item_2 <- calcEscore(item_2, seq(-3, 3, 1))
item_3     <- new("item_3PL", slope = 1.0, difficulty = 0.5, guessing = 0.2)
ICC_item_3 <- calcEscore(item_3, seq(-3, 3, 1))
item_4     <- new("item_PC", threshold = c(-1, 0, 1), ncat = 4)
ICC_item_4 <- calcEscore(item_4, seq(-3, 3, 1))
item_5     <- new("item_GPC", slope = 1.2, threshold = c(-0.8, -1.0, 0.5), ncat = 4)
ICC_item_5 <- calcEscore(item_5, seq(-3, 3, 1))
item_6     <- new("item_GR", slope = 0.9, category = c(-1, 0, 1), ncat = 4)
ICC_item_6 <- calcEscore(item_6, seq(-3, 3, 1))
TCC_itempool <- calcEscore(itempool_science, seq(-3, 3, 1))
}
\references{
{
  \insertRef{rasch_probabilistic_1960}{TestDesign}
}

{
  \insertRef{lord_theory_1952}{TestDesign}

  \insertRef{birnbaum_efficient_1957}{TestDesign}

  \insertRef{birnbaum_estimation_1958}{TestDesign}

  \insertRef{birnbaum_further_1958}{TestDesign}
}

{
  \insertRef{birnbaum_latent_1968}{TestDesign}
}

{
  \insertRef{masters_rasch_1982}{TestDesign}

  \insertRef{andrich_rating_1978}{TestDesign}
}

{
  \insertRef{muraki_generalized_1992}{TestDesign}
}

{
  \insertRef{samejima_estimation_1969}{TestDesign}
}
}
