#' @title Polygon layer of Dallas County, TX, census block groups
#' @description Block groups in Dallas County, Texas, in the longitude and
#'   latitude format (see \code{proj4string=CRS("+proj=longlat +ellps=WGS84")}).
#'
#'   \strong{Note}: Several fields have missing observations and several variables
#'   are reported as absolute numbers.
#' @docType data
#' @name blockGroupShp
#' @source Based on 2018 ACS data, which were retrieved from Maptitude
#' (\url{https://www.caliper.com/}).
#' @format Spatial polygon data-frame with 1669 block groups. The variables are
#' as follows:
#' \describe{
#'   \item{ID}{Internal ID.}
#'   \item{BLOCKGROUP}{Factor with the Census Bureau's block group number.}
#'   \item{TRACT}{Factor with the Census Bureau's tract numbers.}
#'   \item{AREA}{Calculated area of the block group in square miles.}
#'   \item{LANDAREA}{Land area of the block group in square miles.}
#'   \item{WATERAREA}{Water area of the block group in square miles.}
#'   \item{DAYPOP}{Caliper's estimate of the absolute day time population 16 yrs and older.}
#'   \item{NIGHTPOP}{Census's night time population counts in a block group.}
#'   \item{MEDAGE}{Median population age in a block group.}
#'   \item{WHITE}{Absolute number of white population in a block group.}
#'   \item{PCTBLACK}{Absolute number of black population in a block group.}
#'   \item{PCTASIAN}{Absolute number of asian population in a block group.}
#'   \item{PCTHISPAN}{Absolute number of hispanic population in a block group.}
#'   \item{PCTHIGH}{\% of population 25+ with a high school degree.}
#'   \item{PCTUNIVDEG}{\% of population 25+ with a univeristy degrees.}
#'   \item{TIME2WORK}{Average travel time to work. \strong{Attention}: 1421 NA's.}
#'   \item{PERCAPINC}{Per capita income in $.}
#'   \item{HOUSEUNITS}{Absolute number of housing units}
#'   \item{PCTOWNVAC}{\% of vacant owner occupied housing units.}
#'   \item{PCTRENTVAC}{\% of vacant rental housing units.}
#' }
#' @examples
#' data(blockGroupShp)
#' sp::summary(blockGroupShp)
NULL
