% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapColorRamp.R
\name{mapColorRamp}
\alias{mapColorRamp}
\title{Function: Maps a sequential color theme}
\usage{
mapColorRamp(var.name, shape, breaks=8, map.title="",
                    legend.title=deparse(substitute(var.name)),
                    legend.pos="bottomleft", legend.cex=1, add.to.map=FALSE)
}
\arguments{
\item{var.name}{A variable to be mapped in a bipolar theme. If it is in a data-frame,
then the data-frame must be refered to, e.g., \code{df$var}}

\item{shape}{An existing spatial polygon or spatial polygon data-frame}

\item{breaks}{Number of qunatiles. It needs to range the range of 3 to 9}

\item{map.title}{Character string with map title}

\item{legend.title}{Character string with legend title (default=\code{var.name})}

\item{legend.pos}{Location of legend in the map frame (default=\code{"bottomleft"})}

\item{legend.cex}{Relative font size of the legend}

\item{add.to.map}{Logical to start a new map frame if \code{FALSE} or overlay onto an
existing map frame if \code{TRUE}}
}
\value{
\code{NULL}
}
\description{
\code{mapColorRamp} generates a map with a sequential theme of an interval scaled variable
}
\details{
The function \code{mapColorRamp} maps an \emph{interval scaled variable} by a
  \emph{sequetial color ramp}. Quantiles values are coded in gradually increasing
  intensities of oranges. A legend is generated. NA's are permitted.
}
\examples{
library(maptools)
validTractShp <- tractShp[!is.na(tractShp$BUYPOW), ]         # Remove 2 tracts with NA's
mapColorQual(validTractShp$CITYPERI, validTractShp,
             map.title="Cities and Peripherie in Dallas County",
             legend.title="Regions")

mapColorRamp(validTractShp$bad1500D, validTractShp, breaks=9,
             map.title="Density of Convenience Stores in Dallas County\nbw=1500 meters",
             legend.title="Junk Food")

hist(tractShp$LRRmedD)
mapBiPolar(validTractShp$LRRmedD, validTractShp, break.value=0,
           neg.breaks=5, pos.breaks=5,
           map.title="LRR: log(f(junk food),f(healthy food))\nbw=medium",
           legend.title="log relative risk")

}
\author{
Michael Tiefelsdorf <tiefelsdorf@utdallas.edu>
}
