% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6-CDMInterface.R
\name{CDMInterface}
\alias{CDMInterface}
\title{CDMInterface}
\description{
Abstract interface to the CDM, using CDMConnector or DatabaseConnector.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CDMInterface-new}{\code{CDMInterface$new()}}
\item \href{#method-CDMInterface-validate}{\code{CDMInterface$validate()}}
\item \href{#method-CDMInterface-fetchCohortTable}{\code{CDMInterface$fetchCohortTable()}}
\item \href{#method-CDMInterface-addAge}{\code{CDMInterface$addAge()}}
\item \href{#method-CDMInterface-addSex}{\code{CDMInterface$addSex()}}
\item \href{#method-CDMInterface-fetchMetadata}{\code{CDMInterface$fetchMetadata()}}
\item \href{#method-CDMInterface-destroy}{\code{CDMInterface$destroy()}}
\item \href{#method-CDMInterface-clone}{\code{CDMInterface$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CDMInterface-new"></a>}}
\if{latex}{\out{\hypertarget{method-CDMInterface-new}{}}}
\subsection{Method \code{new()}}{
Initializer method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CDMInterface$new(
  connectionDetails = NULL,
  cdmSchema = NULL,
  resultSchema = NULL,
  cdm = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{connectionDetails}}{(\code{DatabaseConnector::createConnectionDetails()}: \code{NULL})\cr
Optional; In congruence with \code{cdmSchema} and \code{resultSchema}. Ignores \code{cdm}.}

\item{\code{cdmSchema}}{(\code{character(1)}: \code{NULL})\cr
Optional; In congruence with \code{connectionDetails} and \code{resultSchema}. Ignores \code{cdm}.}

\item{\code{resultSchema}}{(\code{character(1)}: \code{NULL})\cr
Optional; In congruence with \code{connectionDetails} and \code{cdmSchema}. Ignores \code{cdm}.}

\item{\code{cdm}}{(\code{CDMConnector::cdm_from_con()}: \code{NULL})\cr
Optional; Ignores \code{connectionDetails}, \code{cdmSchema}, and \code{resultSchema}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{invisible(self)})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CDMInterface-validate"></a>}}
\if{latex}{\out{\hypertarget{method-CDMInterface-validate}{}}}
\subsection{Method \code{validate()}}{
Validation method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CDMInterface$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{invisible(self)})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CDMInterface-fetchCohortTable"></a>}}
\if{latex}{\out{\hypertarget{method-CDMInterface-fetchCohortTable}{}}}
\subsection{Method \code{fetchCohortTable()}}{
Fetch specified cohort IDs from a specified cohort table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CDMInterface$fetchCohortTable(cohortIds, cohortTableName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cohortIds}}{(\code{integer(1)})\cr
Cohort ID's of cohorts to investigate.}

\item{\code{cohortTableName}}{(\code{character(1)})\cr
Cohort table name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{data.frame})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CDMInterface-addAge"></a>}}
\if{latex}{\out{\hypertarget{method-CDMInterface-addAge}{}}}
\subsection{Method \code{addAge()}}{
Stratisfy the treatmentHistory data frame by age.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CDMInterface$addAge(andromeda)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{andromeda}}{(\code{Andromeda::andromeda()})
Andromeda object.}

\item{\code{andromeda}}{(\code{Andromeda::andromeda()})
Andromeda object.}

\item{\code{andromeda}}{(\code{Andromeda::andromeda()})
Andromeda object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{data.frame()})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CDMInterface-addSex"></a>}}
\if{latex}{\out{\hypertarget{method-CDMInterface-addSex}{}}}
\subsection{Method \code{addSex()}}{
Stratisfy the treatmentHistory data frame by sex.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CDMInterface$addSex(andromeda)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{andromeda}}{(\code{Andromeda::andromeda()})
Andromeda object.}

\item{\code{andromeda}}{(\code{Andromeda::andromeda()})
Andromeda object.}

\item{\code{andromeda}}{(\code{Andromeda::andromeda()})
Andromeda object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{data.frame()})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CDMInterface-fetchMetadata"></a>}}
\if{latex}{\out{\hypertarget{method-CDMInterface-fetchMetadata}{}}}
\subsection{Method \code{fetchMetadata()}}{
Fetch metadata from CDM
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CDMInterface$fetchMetadata(andromeda)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{andromeda}}{(\code{Andromeda::andromeda()})
Andromeda object.}

\item{\code{andromeda}}{(\code{Andromeda::andromeda()})
Andromeda object.}

\item{\code{andromeda}}{(\code{Andromeda::andromeda()})
Andromeda object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{invisible(NULL)})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CDMInterface-destroy"></a>}}
\if{latex}{\out{\hypertarget{method-CDMInterface-destroy}{}}}
\subsection{Method \code{destroy()}}{
Destroys instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CDMInterface$destroy()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(NULL)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CDMInterface-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CDMInterface-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CDMInterface$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
