% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{tlsNormalize}
\alias{tlsNormalize}
\title{Normalize a TLS point cloud}
\usage{
tlsNormalize(las, res = 0.5, keepGround = TRUE)
}
\arguments{
\item{las}{\code{LAS} object.}

\item{res}{\code{numeric} - resolution of the DTM used for normalization.}

\item{keepGround}{\code{logical} - if \code{TRUE} (default), returns a normalized point cloud with classified ground, otherwise removes the ground points.}
}
\value{
\code{LAS} object.
}
\description{
Fast normalization of TLS point clouds based on a Digital Terrain Model (DTM) of the ground points. If the input's ground points are not classified, the \code{\link[lidR:csf]{csf}} algorithm is applied internally.
}
\examples{
file = system.file("extdata", "pine_plot.laz", package="TreeLS")
tls = readTLS(file)
plot(tls)
rgl::axes3d(col='white')

### remove topography effect
tls = tlsNormalize(tls, 0.5, FALSE)
plot(tls)
rgl::axes3d(col='white')

}
