% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_methods.R
\name{voxelize}
\alias{voxelize}
\title{Point sampling algorithm: systematic voxel grid}
\usage{
voxelize(spacing = 0.05)
}
\arguments{
\item{spacing}{\code{numeric} - voxel side length.}
}
\description{
This function is meant to be used inside \code{\link{tlsSample}}. It selects one random point per voxel at a given spatial resolution.
}
\examples{
file = system.file("extdata", "pine.laz", package="TreeLS")
tls = readTLS(file)
print(tls)

### thin point cloud - note the point count
tls = tlsSample(tls, voxelize(0.05))
print(tls)

}
