% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ratchet.R
\name{Ratchet}
\alias{Ratchet}
\title{Parsimony Ratchet}
\usage{
Ratchet(tree, dataset, TreeScorer = FitchScore, returnAll = FALSE,
  rooted = TRUE, ratchIter = 100, ratchHits = 10, searchIter = 2000,
  searchHits = 40, bootstrapIter = searchIter, bootstrapHits = searchHits,
  verbosity = 0, rearrangements = "NNI", suboptimal = 1e-08, ...)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}}

\item{dataset}{a dataset in the format required by TreeScorer}

\item{TreeScorer}{Function to score trees, to receive arguments \code{tree} and \code{dataset}.}

\item{returnAll}{Set to \code{TRUE} to report all MPTs encountered during the search, perhaps to analyze consensus}

\item{rooted}{whether to retain the position of the root in tree search (TRUE by default)}

\item{ratchIter}{stop when this many ratchet iterations have been performed}

\item{ratchHits}{stop when this many ratchet iterations have found the same best score}

\item{searchIter}{maximum rearrangements to perform on each bootstrap or ratchet iteration;}

\item{searchHits}{maximum times to hit best score before terminating a tree search within a ratchet iteration;}

\item{bootstrapIter}{maximum rearrangements to perform on each bootstrap  iteration (default: \code{maxIter})}

\item{bootstrapHits}{maximum times to hit best score on each bootstrap  iteration (default: \code{maxHits})}

\item{verbosity}{verbosity of output written to terminal; higher values print more messages}

\item{rearrangements}{method(s) to use when rearranging trees. Provide:
the character string "TBR" to conduct TBR, SPR and NNI rearrangements, or "TBR only"
to just perform TBR rearrangements (retaining the position of the root if \code{outgroup = TRUE})
OR: a list of functions to use, one at a time, as the \code{Rearrange} parameter
    in successive calls to TreeSearch}

\item{suboptimal}{retain trees that are suboptimal by this score. Defaults to 1e-08 to counter rounding errors.}

\item{\dots}{further arguments to pass to \code{TreeScorer} function (e.g. \code{\link{TipsAreColumns}}, \code{dataset})}
}
\value{
This function returns a tree modified by parsimony ratchet iteration, retaining the position of the root.
}
\description{
\code{Ratchet} uses the parsimony ratchet (Nixon 1999) to search for a more parsimonious tree.
}
\examples{
Ratchet(RandomTree(Lobo.phy), Lobo.phy, rooted=TRUE,
                  ratchHits=2, ratchIter=5, searchIter=200, searchHits=5)

}
\references{
Nixon, K. C. (1999). \cite{The Parsimony Ratchet, a new method for rapid parsimony analysis.} Cladistics, 15(4), 407-414. doi:\href{http://dx.doi.org/10.1111/j.1096-0031.1999.tb00277.x}{10.1111/j.1096-0031.1999.tb00277.x}
}
\seealso{
\code{\link{Ratchet}}

\code{\link{TreeSearch}}

\code{\link{Sectorial}}
}
\author{
Martin R. Smith

Adapted from \code{\link[phangorn]{pratchet}} in the \pkg{phangorn} package, which does not preserve the position of the root.
}
\keyword{tree}
