% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_rearrangement.R
\name{RearrangeTree}
\alias{RearrangeTree}
\title{Rearrange phylogenetic tree}
\usage{
RearrangeTree(tree, TreeScorer = FitchScore, Rearrange = RootedNNI,
  minScore = NULL, returnSingle = TRUE, iter = "<unknown>",
  verbosity = 0, ...)
}
\arguments{
\item{tree}{a rooted bifurcating phylogenetic tree with the desired outgroup, with its labels
in an order that matches the Morphy object, and the attributes
\code{pscore}, the tree's parsimony score, and 
\code{hits}, the number of times the best score has been hit in the calling function;}

\item{TreeScorer}{function by which trees should be scored; default \code{\link{FitchScore}}}

\item{Rearrange}{a rearrangement function: probably one of 
\code{\link{RootedNNI}}, \code{\link{RootedSPR}} or \code{\link{RootedTBR}};}

\item{minScore}{trees longer than \code{minScore}, probably the score of the starting tree,
will be discarded;}

\item{returnSingle}{returns all trees if \kbd{FALSE} or a randomly selected tree if \kbd{TRUE};}
\item{iter}{iteration number of calling function, for reporting to user only;}

\item{verbosity}{verbosity of output written to terminal; higher values print more messages}

\item{\dots}{further arguments to pass to \code{TreeScorer} function (e.g. \code{\link{TipsAreColumns}}, \code{dataset})}
}
\value{
{This function returns the most parsimonious of the trees generated, with attributes \code{hits} and \code{pscore}
 as described for argument \code{tree}, and with tip labels ordered to match morphyObj.}
}
\description{
Rearrange phylogenetic tree
}
\details{
\code{RearrangeTree} performs one tree rearrangement of a specified type
}
\examples{
data('Lobo')
random.tree <- RandomTree(Lobo.phy)
RearrangeTree(random.tree, dataset=Lobo.phy, Rearrange=RootedNNI)

}
\seealso{
\itemize{
    \item \code{\link{RootedNNI}}
    \item \code{\link{RootedSPR}}
    \item \code{\link{RootedTBR}}
  }
}
\author{
Martin R. Smith
}
