% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPR.R
\name{SPR}
\alias{SPR}
\alias{SPRCore}
\alias{RootedSPR}
\alias{RootedSPRCore}
\title{Subtree Pruning and Rearrangement}
\usage{
SPR(tree, edgeToBreak = NULL, mergeEdge = NULL)

SPRCore(parent, child, nEdge = length(parent), nNode = nEdge/2L,
  edgeToBreak = NULL, mergeEdge = NULL)

RootedSPR(tree, edgeToBreak = NULL, mergeEdge = NULL)

RootedSPRCore(parent, child, nEdge = length(parent), nNode = nEdge/2L,
  edgeToBreak = NULL, mergeEdge = NULL)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}}

\item{edgeToBreak}{the index of an edge to bisect, generated randomly if not specified.}

\item{mergeEdge}{the index of an edge on which to merge the broken edge.}

\item{parent}{the first column of the edge matrix of a tree of class \code{\link{phylo}}, i.e. tree$edge[, 1]}

\item{child}{the second column of the edge matrix of a tree of class \code{\link{phylo}}, i.e. tree$edge[, 2]}

\item{nEdge}{(optional) Number of edges.}

\item{nNode}{(optional) Number of nodes.}
}
\value{
This function returns a tree in \code{phyDat} format that has undergone one \acronym{SPR} iteration.

a list containing two elements, corresponding in turn to the rearranged parent and child parameters

a list containing two elements, corresponding in turn to the rearranged parent and child parameters
}
\description{
Perform one \acronym{SPR} rearrangement on a tree

Rooted SPR
}
\details{
Equivalent to phangorn's kSPR, but faster.
Note that rearrangements that only change the position of the root WILL be returned by 
\code{SPR}.  If the position of the root is irrelevant (as in Fitch parsimony, for example)
then this function will occasionally return a functionally equivalent topology.  
\code{RootIrrelevantSPR} will search tree space more efficiently in these cases.
Branch lengths are not (yet) supported.
}
\section{Functions}{
\itemize{
\item \code{SPRCore}: faster version that takes and returns parent and child parameters

\item \code{RootedSPR}: Perform \acronym{SPR} rearrangement, retaining position of root

\item \code{RootedSPRCore}: faster version that takes and returns parent and child parameters
}}

\examples{
{
tree <- ape::rtree(20, br=FALSE)
SPR(tree)
}
}
\references{
The \acronym{SPR} algorithm is summarized in
Felsenstein, J. 2004. \cite{Inferring Phylogenies.} Sinauer Associates, Sunderland, Massachusetts.
}
\seealso{
RootedSPR useful when the position of the root node should be retained.

TBR

NNI
}
\author{
Martin R. Smith
}
