% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SuccessiveApproximations.R
\name{SuccessiveApproximations}
\alias{SuccessiveApproximations}
\title{Tree Search using Successive Approximations}
\usage{
SuccessiveApproximations(tree, dataset, outgroup = NULL, k = 3,
  maxSuccIter = 20, ratchetHits = 100, searchHits = 50,
  searchIter = 500, ratchetIter = 5000, verbosity = 0,
  suboptimal = 0.1)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}.}

\item{dataset}{A phylogenetic data matrix of class \code{\link[phangorn]{phyDat}}, whose names 
correspond to the labels of any accompanying tree.}

\item{outgroup}{if not NULL, taxa on which the tree should be rooted}

\item{k}{Constant for successive approximations, see Farris 1969 p. 379}

\item{maxSuccIter}{maximum iterations of successive approximation}

\item{ratchetHits}{maximum hits for parsimony ratchet}

\item{searchHits}{maximum hits in tree search}

\item{searchIter}{maximum iterations in tree search}

\item{ratchetIter}{maximum iterations of parsimony ratchet}

\item{verbosity}{integer (default 0) specifying how much detail to print to stdout}

\item{suboptimal}{retain trees that are this proportion less optimal than the optimal tree}
}
\value{
list of optimal (and slightly suboptimal, if suboptimal > 0) trees
}
\description{
Searches for a tree that is optimal under the Successive Approximations criterion
}
