% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partitions.R
\name{DropSingleSplits}
\alias{DropSingleSplits}
\title{Drop Single Splits}
\usage{
DropSingleSplits(split)
}
\arguments{
\item{split}{A matrix in which each column corresponds to a bipartition split}
}
\value{
The input matrix, with any columns that separate only a single pendant
 tip removed.
}
\description{
Removes splits that pertain only to a single taxon from a splits object.
}
\details{
Bipartition splits are divisions, implied by each edge or node of an unrooted
tree topology, that divide the taxa into two groups (one of which is a clade).

By default, a list of splits will include those that separate a single taxon
(a leaf) from all others.  Such splits are, by definition, present in all 
trees that contain that taxon; they are not of interest when comparing trees.
This function removes such splits from a list of bipartitions.
}
\author{
Martin R. Smith
}
