% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IWScore.R, R/pp_ProfileScore.R
\name{IWScore}
\alias{IWScore}
\alias{IWInitMorphy}
\alias{IWDestroyMorphy}
\title{Implied weights parsimony Score}
\usage{
IWScore(tree, dataset, concavity = 10, ...)

IWInitMorphy(dataset)

IWDestroyMorphy(dataset)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}.}

\item{dataset}{Dataset of class \code{phyDat}.  The dataset should have been
prepared using \code{dataset <- \link{PrepareDataIW}(dataset)}; if this step
has not been completed, the dataset will be (time-consumingly) prepared
within the function.
In subsidiary functions, the dataset will have been initialized using
\code{IWInitMorphy}, and must be destroyed using \code{IWDestroyMorphy}.}

\item{concavity}{A numeric value to use as the concavity constant (\code{k})
in implied weighting. Defaults to 10; TNT sets a default of 3, but this
is too low in some circumstances (Smith, 2019).}

\item{\dots}{unused; allows additional parameters specified within \dots to be
received by the function without throwing an error.}
}
\value{
The 'fit', \code{h / h + k}, where \code{h} is the amount of homoplasy ('extra steps')
and \code{k} is a constant (the 'concavity constant')
}
\description{
Calculate a tree's Parsimony score with a given dataset using implied weights
(Goloboff 1997).
}
\section{Functions}{
\itemize{
\item \code{IWInitMorphy}: Initialize dataset by adding \code{morphyObjs} and
\code{min.length} properties.

\item \code{IWDestroyMorphy}: Free memory from \code{morphyObjs} initialized by
\code{IWScoreMorphy()}.
}}

\examples{
  data(referenceTree)
  data(congreveLamsdellMatrices)
  dataset <- PrepareDataIW(congreveLamsdellMatrices[[42]])
  IWScore(referenceTree, dataset)

}
\references{
\itemize{
\item \insertRef{Goloboff1997}{TreeSearch}
\item \insertRef{SmithTern}{TreeSearch}
}
}
\seealso{
Other tree scoring: 
\code{\link{CharacterLength}()},
\code{\link{Fitch}()},
\code{\link{MorphyTreeLength}()}
}
\author{
Martin R. Smith
}
\concept{tree scoring}
\keyword{tree}
