% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpl_morphyex.R
\name{mpl_update_lower_root}
\alias{mpl_update_lower_root}
\title{Updates the nodal sets for a lower ('dummy') root node}
\usage{
mpl_update_lower_root(l_root_id, root_id, morphyobj)
}
\arguments{
\item{l_root_id}{The index of the lower root.}

\item{root_id}{The index of the upper root node.}

\item{morphyobj}{An instance of the Morphy object.}
}
\value{
A Morphy error code.
}
\description{
If trees are rooted, then Morphy uppass functions
require a lower or 'dummy' root in order to function properly. This
function should be called to set the nodal state sets to the dummy
root. The nodal set will be equal to the set of the root node, unless
there is an ambiguous union of applicable and gap tokens when gaps are
treated as in applicable. In which case, the set union is resolved in
favour of any applicable tokens in the set.
}
\seealso{
Other Morphy API functions: 
\code{\link{MorphyErrorCheck}()},
\code{\link{MorphyWeights}()},
\code{\link{PhyDat2Morphy}()},
\code{\link{SetMorphyWeights}()},
\code{\link{SingleCharMorphy}()},
\code{\link{UnloadMorphy}()},
\code{\link{mpl_apply_tipdata}()},
\code{\link{mpl_attach_rawdata}()},
\code{\link{mpl_attach_symbols}()},
\code{\link{mpl_delete_Morphy}()},
\code{\link{mpl_delete_rawdata}()},
\code{\link{mpl_first_down_recon}()},
\code{\link{mpl_first_up_recon}()},
\code{\link{mpl_get_charac_weight}()},
\code{\link{mpl_get_num_charac}()},
\code{\link{mpl_get_num_internal_nodes}()},
\code{\link{mpl_get_numtaxa}()},
\code{\link{mpl_get_symbols}()},
\code{\link{mpl_init_Morphy}()},
\code{\link{mpl_new_Morphy}()},
\code{\link{mpl_second_down_recon}()},
\code{\link{mpl_second_up_recon}()},
\code{\link{mpl_set_charac_weight}()},
\code{\link{mpl_set_num_internal_nodes}()},
\code{\link{mpl_set_parsim_t}()},
\code{\link{mpl_translate_error}()},
\code{\link{mpl_update_tip}()},
\code{\link{summary.morphyPtr}()}
}
\author{
Thomas Guillerme
}
\concept{Morphy API functions}
\keyword{internal}
