% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SplitFunctions.R
\name{TrivialSplits}
\alias{TrivialSplits}
\alias{WithoutTrivialSplits}
\title{Are splits trivial?}
\usage{
TrivialSplits(splits, nTip = attr(splits, "nTip"))

WithoutTrivialSplits(splits, nTip = attr(splits, "nTip"))
}
\arguments{
\item{splits}{An object of class \code{\link[=as.Splits]{Splits}}.}

\item{nTip}{Integer specifying number of tips (leaves).}
}
\value{
Logical vector specifying whether each split in \code{splits} is trivial,
i.e. includes or excludes only a single tip or no tips at all.
}
\description{
Are splits trivial?
}
\section{Functions}{
\itemize{
\item \code{WithoutTrivialSplits}: Remove trivial splits from a splits object
}}

\examples{

splits <- as.Splits(PectinateTree(letters[1:9]))
efgh <- Subsplit(splits, tips = letters[5:8], keepAll = TRUE)
summary(efgh)

TrivialSplits(efgh)

}
\seealso{
Other split manipulation functions: 
\code{\link{Subsplit}()}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{split manipulation functions}
