% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Splits.R
\name{match.Splits}
\alias{match.Splits}
\title{Match splits}
\usage{
match.Splits(x, table, nomatch = NA_integer_, incomparables = NULL)
}
\arguments{
\item{x, table}{Object of class \code{Splits}.}

\item{nomatch}{The value to be returned in the case where no match is found.}

\item{incomparables}{A vector of values that cannot be matched. Any value in
\code{x} matching a value in this vector is assigned the \code{nomatch} value.
For historical reasons, \code{FALSE} is equivalent to \code{NULL}.}
}
\value{
An integer vector specifying the position in \code{table} that matches
each element in \code{x}, or \code{nomatch} if no match is found.
}
\description{
Equivalent of \code{match} for \code{Splits} objects.
}
\examples{
splits1 <- as.Splits(BalancedTree(7))
splits2 <- as.Splits(PectinateTree(7))

match.Splits(splits1, splits2)

}
\seealso{
Other Splits operations: 
\code{\link{NSplits}()},
\code{\link{NTip}()},
\code{\link{TipLabels}()},
\code{\link{TipsInSplits}()},
\code{\link{as.Splits}()},
\code{\link{in.Splits}()}
}
\concept{Splits operations}
