% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/M_empirical.R
\name{M_empirical}
\alias{M_empirical}
\title{Empirical formulas for the estimation of natural mortality}
\source{
https://cran.r-project.org/web/packages/fishmethods/index.html
}
\usage{
M_empirical(Linf = NULL, Winf = NULL, K_l = NULL, K_w = NULL,
  temp = NULL, tmax = NULL, tm50 = NULL, GSI = NULL, Wdry = NULL,
  Wwet = NULL, Bl = NULL, schooling = FALSE, method)
}
\arguments{
\item{Linf}{infinite total length (TL) from a von Bertalanffy
growth curve in cm.}

\item{Winf}{infinite weight form a von Bertalanffy growth curve
in wet weight-grams.}

\item{K_l}{is the growth coefficient (per year) from a von Bertalanffy growth
curve for length.}

\item{K_w}{is the growth coefficient (per year) from a von Bertalanffy growth
curve for weight.}

\item{temp}{average annual temperature at the surface in degrees centigrade.}

\item{tmax}{the oldest age observed for the species.}

\item{tm50}{age when 50\% of the population is mature [year]
("age of massive maturation").}

\item{GSI}{gonadosomatic index (wet ovary weight over wet body weight).}

\item{Wdry}{total dry weight in grams.}

\item{Wwet}{total wet weight at mean length in grams.}

\item{Bl}{vector with body lengths in cm for size dependent mortality estimates (method = "Gislason")}

\item{schooling}{logical; if TRUE it is accounted for the schooling behaviour of
the species, only for Pauly's methods. Default is FALSE.}

\item{method}{vector of method names. Any combination of following methods can
be employed: "AlversonCarney", "Gislason" (size dependent mortality estimates), "GundersonDygert", "Hoenig",
"Lorenzen", "Pauly_Linf", "Pauly_Winf", "PetersonWroblewski",
"RikhterEfanov", "Roff". Please refer to Details to see which input parameters
are required by each method.}
}
\value{
A matrix of M estimates.
}
\description{
Functions to calculate the instantaneous natural mortality rate (M)
     according to 12 different empirical formulas.
}
\details{
Function adapted from the mortality function of the fishmethods package
    by Gary A. Nelson
    (https://cran.r-project.org/web/packages/fishmethods/index.html).

Depending on the method different input parameters are required:
\itemize{
   \item \code{"AlversonCarney"} requires \code{K_l} and \code{tmax},
   \item \code{"Gislason"} requires \code{Linf}, \code{K_l} and \code{Bl},
   \item \code{"GundersonDygert"} requires \code{GSI},
   \item \code{"Hoenig"} requires \code{tmax},
   \item \code{"Lorenzen"} requires \code{Wwet},
   \item \code{"Pauly_Linf"} requires \code{Linf}, \code{K_l} and \code{temp},
   \item \code{"Pauly_Winf"} requires \code{Winf}, \code{K_w} and \code{temp},
   \item \code{"PetersonWroblewski"} requires \code{Wdry},
   \item \code{"RikhterEfanov"} requires \code{tm50},
   \item \code{"Roff"} requires \code{K_l} and \code{tm50},
   \item \code{"Then_tmax"} requires \code{tmax},
   \item \code{"Then_growth"} requires \code{Linf} and \code{K_l}.
}
If accounting for schooling behaviour M is multiplied by 0.8 according to
   Pauly (1983).
}
\examples{
M_empirical(Linf = 80, K_l = 0.5, temp = 25, tmax = 30,
     method = c("Pauly_Linf","Hoenig"))

}
\references{
Alverson, D. L. and M. J. Carney. 1975. A graphic review of the growth and decay
of population cohorts. J. Cons. Int. Explor. Mer 36: 133-143.

Gislason, H., N. Daan, J. C. Rice, and J. G. Pope. 2010. Size, growth,
temperature and the natural mortality of marine fish. Fish and Fisheries 11: 149-158.

Gunderson, D. R. and P. H. Dygert. 1988. Reproductive effort as a predictor
of natural mortality rate. J. Cons. Int. Explor. Mer 44: 200-209.

Hoenig, J. M. 1983. Empirical use of longevity data to estimate mortality rates.
Fish. Bull. 82: 898-903.

Lorenzen, K. 1996. The relationship between body weight and natural mortality in
juvenile and adult fish: a comparison of natural ecosystems and aquaculture.
J. Fish. Biol. 49: 627-647.

Pauly, D. 1980. On the interrelationships between natural mortality,
growth parameters, and mean environmental temperature in 175 fish stocks.
J. Cons. Int. Explor. Mer: 175-192.

Pauly, D., 1983. Some simple methods for the assessment of tropical fish stocks.
\emph{FAO Fish.Tech.Pap.}, (234): 52p. Issued also in French and Spanish

Peterson, I. and J. S. Wroblewski. 1984. Mortality rate of fishes in the
pelagic ecosystem. Can. J. Fish. Aquat. Sci. 41: 1117-1120.

Rikhter, V.A., and V.N. Efanov, 1976. On one of the approaches to estimation of natural
mortality of fish populations. \emph{ICNAF Res.Doc.}, 76/VI/8: 12p.

Roff, D. A. 1984. The evolution of life history parameters in teleosts.
Can. J. Fish. Aquat. Sci. 41: 989-1000.

Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. \emph{FAO Fisheries Technical Paper}, (306.1, Rev. 2). 407 p.

Then, A. Y., J. M. Hoenig, N. G. Hall, D. A. Hewitt. 2015. Evaluating the predictive 
performance of empirical estimators of natural mortality rate using information on over 
200 fish species. ICES J. Mar. Sci. 72: 82-92.
}
\keyword{M}
\keyword{function}
\keyword{mortality}

