% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfqCreate.R
\name{lfqCreate}
\alias{lfqCreate}
\title{Create lfq data from length measurements}
\usage{
lfqCreate(data, Lname, Dname, bin_size = 2, length_unit = "cm",
  plus_group = FALSE, aggregate_dates = FALSE, plot = FALSE)
}
\arguments{
\item{data}{data with at least two columns, one with the length measurements, one
with the sampling date}

\item{Lname}{name of the length column}

\item{Dname}{name of the date column}

\item{bin_size}{size of the bins in cm (Default: 2)}

\item{length_unit}{unit of length measurements, either "cm" (default), "mm" or "m"}

\item{plus_group}{logical; should a plus group be created? If yes you will be
asked to insert the length for the plus group in the console. (Default: FALSE)}

\item{aggregate_dates}{logical; indicating whether dates should be lumped in monthly
sampling times (assuming sampling always aound the 15th of
each month; default is FALSE). More exact lumping can only done manually and
then sampling dates provided in data.}

\item{plot}{logical; should a graph of lfq data be displayed? (Default: FALSE)}
}
\value{
A list of "lfq" class with
   \itemize{
   \item \strong{dates} dates of sampling times (class Date),
   \item \strong{midLengths} midpoints of the length classes,
   \item \strong{catch} matrix with catches/counts per length class (row) and
  sampling date (column).
   }
}
\description{
Convert raw length measurements to length frequency data (lfq class).
}
\examples{
# create random data
set.seed(1)
data <- data.frame(length.mm. = sample(c(rpois(300, lambda = 60),
           rpois(200, lambda = 100), rpois(100, lambda = 150)),
           size = 1000, replace = TRUE),
           dates = seq.Date(as.Date("2015-10-02"),as.Date("2016-08-28"),
           length.out = 1000))
# create lfq data
lfq_dat <- lfqCreate(data,Lname = "length.mm.", Dname = "dates", aggregate_dates = TRUE,
   length_unit = "mm", bin_size = 0.5, plot=TRUE)

}
\keyword{function}
\keyword{length-frequency}
\keyword{lfq}

