
### Abbreviations

#### TCGA cancer types

| Study Abbreviation | Study Name                                                   |
| :----------------- | :----------------------------------------------------------- |
| LAML               | Acute Myeloid Leukemia                                       |
| ACC                | Adrenocortical carcinoma                                     |
| BLCA               | Bladder Urothelial Carcinoma                                 |
| LGG                | Brain Lower Grade Glioma                                     |
| BRCA               | Breast invasive carcinoma                                    |
| CESC               | Cervical squamous cell carcinoma and endocervical adenocarcinoma |
| CHOL               | Cholangiocarcinoma                                           |
| LCML               | Chronic Myelogenous Leukemia                                 |
| COAD               | Colon adenocarcinoma                                         |
| CNTL               | Controls                                                     |
| ESCA               | Esophageal carcinoma                                         |
| FPPP               | FFPE Pilot Phase II                                          |
| GBM                | Glioblastoma multiforme                                      |
| HNSC               | Head and Neck squamous cell carcinoma                        |
| KICH               | Kidney Chromophobe                                           |
| KIRC               | Kidney renal clear cell carcinoma                            |
| KIRP               | Kidney renal papillary cell carcinoma                        |
| LIHC               | Liver hepatocellular carcinoma                               |
| LUAD               | Lung adenocarcinoma                                          |
| LUSC               | Lung squamous cell carcinoma                                 |
| DLBC               | Lymphoid Neoplasm Diffuse Large B-cell Lymphoma              |
| MESO               | Mesothelioma                                                 |
| MISC               | Miscellaneous                                                |
| OV                 | Ovarian serous cystadenocarcinoma                            |
| PAAD               | Pancreatic adenocarcinoma                                    |
| PCPG               | Pheochromocytoma and Paraganglioma                           |
| PRAD               | Prostate adenocarcinoma                                      |
| READ               | Rectum adenocarcinoma                                        |
| SARC               | Sarcoma                                                      |
| SKCM               | Skin Cutaneous Melanoma                                      |
| STAD               | Stomach adenocarcinoma                                       |
| TGCT               | Testicular Germ Cell Tumors                                  |
| THYM               | Thymoma                                                      |
| THCA               | Thyroid carcinoma                                            |
| UCS                | Uterine Carcinosarcoma                                       |
| UCEC               | Uterine Corpus Endometrial Carcinoma                         |
| UVM                | Uveal Melanoma                                               |

#### TCGA sample type codes

| Code | Definition                                        | Short Letter Code |
| :--- | :------------------------------------------------ | :---------------- |
| 01   | Primary Solid Tumor                               | TP                |
| 02   | Recurrent Solid Tumor                             | TR                |
| 03   | Primary Blood Derived Cancer - Peripheral Blood   | TB                |
| 04   | Recurrent Blood Derived Cancer - Bone Marrow      | TRBM              |
| 05   | Additional - New Primary                          | TAP               |
| 06   | Metastatic                                        | TM                |
| 07   | Additional Metastatic                             | TAM               |
| 08   | Human Tumor Original Cells                        | THOC              |
| 09   | Primary Blood Derived Cancer - Bone Marrow        | TBM               |
| 10   | Blood Derived Normal                              | NB                |
| 11   | Solid Tissue Normal                               | NT                |
| 12   | Buccal Cell Normal                                | NBC               |
| 13   | EBV Immortalized Normal                           | NEBV              |
| 14   | Bone Marrow Normal                                | NBM               |
| 15   | sample type 15                                    | 15SH              |
| 16   | sample type 16                                    | 16SH              |
| 20   | Control Analyte                                   | CELLC             |
| 40   | Recurrent Blood Derived Cancer - Peripheral Blood | TRB               |
| 50   | Cell Lines                                        | CELL              |
| 60   | Primary Xenograft Tissue                          | XP                |
| 61   | Cell Line Derived Xenograft Tissue                | XCL               |
| 99   | sample type 99                                    | 99SH              |

#### TCGA platform codes

| Platform Code                         | Platform Alias                     | Platform Name                                                |
| :------------------------------------ | :--------------------------------- | :----------------------------------------------------------- |
| HT_HG-U133A                           | HT_HG-U133A                        | Affymetrix HT Human Genome U133 Array Plate Set              |
| HuEx-1_0-st-v2                        | HuEx-1_0-st-v2                     | Affymetrix Human Exon 1.0 ST Array                           |
| Genome_Wide_SNP_6                     | Genome_Wide_SNP_6                  | Affymetrix Genome-Wide Human SNP Array 6.0                   |
| HG-CGH-415K_G4124A                    | HG-CGH-415K_G4124A                 | Agilent Human Genome CGH Custom Microarray 2x415K            |
| WHG-CGH_4x44B                         | WHG-CGH_4x44B                      | Agilent Human Genome CGH Microarray 44K                      |
| HG-CGH-244A                           | HG-CGH-244A                        | Agilent Human Genome CGH Microarray 244A                     |
| WHG-1x44K_G4112A                      | 1 x 44K                            | Agilent Whole Human Genome                                   |
| WHG-4x44K_G4112F                      | 4 x 44K                            | Agilent Whole Human Genome Microarray Kit                    |
| AgilentG4502A_07_1                    | AgilentG4502A_07                   | Agilent 244K Custom Gene Expression G4502A-07-1              |
| H-miRNA_G4470A                        | H-miRNA_G4470A                     | Agilent Human miRNA Microarray                               |
| AgilentG4502A_07_2                    | AgilentG4502A_07                   | Agilent 244K Custom Gene Expression G4502A-07-2              |
| H-miRNA_8x15Kv2                       | H-miRNA_8x15K                      | Agilent Human miRNA Microarray Rel12.0                       |
| AgilentG4502A_07_3                    | AgilentG4502A_07                   | Agilent 244K Custom Gene Expression G4502A-07-3              |
| H-miRNA_8x15K                         | H-miRNA_8x15K                      | Agilent 8 x 15K Human miRNA-specific microarray              |
| CGH-1x1M_G4447A                       | CGH-1x1M_G4447A                    | Agilent SurePrint G3 Human CGH Microarray Kit 1x1M           |
| H-miRNA_EarlyAccess                   | H-miRNA_EarlyAccess                | Agilent Human miRNA Early Access Array                       |
| IlluminaGG                            | IlluminaGG                         | Illumina GoldenGate                                          |
| HumanMethylation27                    | HumanMethylation27                 | Illumina Infinium Human DNA Methylation 27                   |
| IlluminaDNAMethylation_OMA003_CPI     | IlluminaDNAMethylation             | Illumina DNA Methylation OMA003 Cancer Panel I               |
| Human1MDuo                            | Human1MDuo                         | Illumina Human1M-Duo BeadChip                                |
| IlluminaDNAMethylation_OMA002_CPI     | IlluminaDNAMethylation             | Illumina DNA Methylation OMA002 Cancer Panel I               |
| HumanHap550                           | HumanHap550                        | Illumina 550K Infinium HumanHap550 SNP Chip                  |
| AgilentG4502A_07                      | AgilentG4502A_07                   | Agilent 244K Custom Gene Expression G4502A-07                |
| bio                                   | bio                                | Biospecimen Metadata - Complete Set                          |
| biotab                                | biotab                             | Biospecimen Metadata - Complete Set - All Samples - Tab-delimited |
| minbio                                | minbio                             | Biospecimen Metadata - Minimal Set                           |
| minbiotab                             | minbiotab                          | Biospecimen Metadata - Minimal Set - All Samples - Tab-delimited |
| ABI                                   | ABI                                | Applied Biosystems Sequence data                             |
| IlluminaHiSeq_DNASeq                  | Mutation Calling                   | Illumina HiSeq 2000 DNA Sequencing                           |
| SOLiD_DNASeq                          | Mutation Calling                   | ABI SOLiD DNA Sequencing                                     |
| IlluminaGA_DNASeq                     | Mutation Calling                   | Illumina Genome Analyzer DNA Sequencing                      |
| IlluminaGA_mRNA_DGE                   | IlluminaGA_mRNA_DGE                | Illumina Genome Analyzer mRNA Digital Gene Expression        |
| 454                                   | 454                                | 454 Life Sciences Genome Sequence data                       |
| HG-U133A_2                            | HG-U133A_2                         | Affymetrix Human Genome U133A 2.0 Array                      |
| HG-U133_Plus_2                        | HG-U133_Plus_2                     | Affymetrix Human Genome U133 Plus 2.0 Array                  |
| Mapping250K_Nsp                       | Mapping250K_Nsp                    | Affymetrix Human Mapping 250K Nsp Array                      |
| Mapping250K_Sty                       | Mapping250K_Sty                    | Affymetrix Human Mapping 250K Sty Array                      |
| GenomeWideSNP_5                       | GenomeWideSNP_5                    | Affymetrix Genome-Wide Human SNP Array 5.0                   |
| tissue_images                         | tissue_images                      | Tissue Images                                                |
| IlluminaGA_RNASeq                     | IlluminaGA_RNASeq                  | Illumina Genome Analyzer RNA Sequencing                      |
| IlluminaGA_miRNASeq                   | IlluminaGA_miRNASeq                | Illumina Genome Analyzer miRNA Sequencing                    |
| diagnostic_images                     | diagnostic_images                  | Diagnostic Images                                            |
| pathology_reports                     | pathology_reports                  | Pathology Reports                                            |
| MDA_RPPA_Core                         | MDA_RPPA_Core                      | M.D. Anderson Reverse Phase Protein Array Core               |
| microsat_i                            | microsat_i                         | Microsatellite Instability Analysis                          |
| HumanMethylation450                   | HumanMethylation450                | Illumina Infinium Human DNA Methylation 450                  |
| IlluminaHiSeq_mRNA_DGE                | IlluminaHiSeq_mRNA_DGE             | Illumina HiSeq 2000 mRNA Digital Gene Expression             |
| IlluminaHiSeq_miRNASeq                | IlluminaHiSeq_miRNASeq             | Illumina HiSeq 2000 miRNA Sequencing                         |
| IlluminaHiSeq_RNASeq                  | IlluminaHiSeq_RNASeq               | Illumina HiSeq 2000 RNA Sequencing                           |
| IlluminaHiSeq_DNASeqC                 | IlluminaHiSeq_DNASeqC              | Illumina HiSeq for Copy Number Variation                     |
| fh_analyses                           | fh_analyses                        | Firehose Analyses                                            |
| fh_stddata                            | fh_stddata                         | Firehose Standardized Data                                   |
| fh_reports                            | fh_reports                         | Firehose Reports                                             |
| IlluminaGA_RNASeqV2                   | IlluminaGA_RNASeqV2                | Illumina Genome Analyzer RNA Sequencing Version 2 analysis   |
| IlluminaHiSeq_RNASeqV2                | IlluminaHiSeq_RNASeqV2             | Illumina HiSeq 2000 RNA Sequencing Version 2 analysis        |
| IlluminaHiSeq_DNASeq_Cont             | Mutation Calling                   | Illumina HiSeq 2000 DNA Sequencing - Controlled              |
| IlluminaGA_DNASeq_Cont                | Mutation Calling                   | Illumina Genome Analyzer DNA Sequencing - Controlled         |
| IlluminaHiSeq_TotalRNASeqV2           | IlluminaHiSeq_TotalRNASeqV2        | Illumina HiSeq 2000 Total RNA Sequencing Version 2 analysis  |
| SOLiD_DNASeq_Cont                     | Mutation Calling                   | ABI SOLiD DNA Sequencing - Controlled                        |
| Mixed_DNASeq                          | Mutation Calling                   | Mixed DNA Sequencing                                         |
| Mixed_DNASeq_Cont                     | Mutation Calling                   | Mixed DNA Sequencing - Controlled                            |
| IlluminaHiSeq_WGBS                    | IlluminaHiSeq_WGBS                 | Illumina HiSeq 2000 Bisulfite-converted DNA Sequencing       |
| IlluminaHiSeq_DNASeq_automated        | Automated Mutation Calling         | IlluminaHiSeq automated DNA sequencing                       |
| IlluminaHiSeq_DNASeq_curated          | Curated Mutation Calling           | IlluminaHiSeq curated DNA sequencing                         |
| IlluminaGA_DNASeq_automated           | Automated Mutation Calling         | IlluminaGA automated DNA sequencing                          |
| IlluminaGA_DNASeq_curated             | Curated Mutation Calling           | IlluminaGA curated DNA sequencing                            |
| SOLiD_DNASeq_automated                | Automated Mutation Calling         | SOLiD automated DNA sequencing                               |
| SOLiD_DNASeq_curated                  | Curated Mutation Calling           | SOLiD curated DNA sequencing                                 |
| Mixed_DNASeq_automated                | Automated Mutation Calling         | Mixed automated DNA sequencing                               |
| Mixed_DNASeq_curated                  | Curated Mutation Calling           | Mixed curated DNA sequencing                                 |
| IlluminaHiSeq_DNASeq_Cont_automated   | Automated Mutation Calling         | IlluminaHiSeq automated DNA sequencing - controlled          |
| IlluminaHiSeq_DNASeq_Cont_curated     | Curated Mutation Calling           | IlluminaHiSeq curated DNA sequencing - controlled            |
| IlluminaGA_DNASeq_Cont_automated      | Automated Mutation Calling         | IlluminaGA automated DNA sequencing - controlled             |
| IlluminaGA_DNASeq_Cont_curated        | Curated Mutation Calling           | IlluminaGA curated DNA sequencing - controlled               |
| SOLiD_DNASeq_Cont_automated           | Automated Mutation Calling         | SOLiD automated DNA sequencing - controlled                  |
| SOLiD_DNASeq_Cont_curated             | Curated Mutation Calling           | SOLiD curated DNA sequencing - controlled                    |
| Mixed_DNASeq_Cont_automated           | Automated Mutation Calling         | Mixed automated DNA sequencing - controlled                  |
| Mixed_DNASeq_Cont_curated             | Curated Mutation Calling           | Mixed curated DNA sequencing - controlled                    |
| supplemental_clinical                 | supplemental_clinical              | supplemental_clinical                                        |
| Multicenter_mutation_calling_MC3      | Multicenter Mutation Calling (MC3) | Multi-Center Mutations                                       |
| Multicenter_mutation_calling_MC3_Cont | Multicenter Mutation Calling (MC3) | Multi-Center Mutations - Controlled                          |

<br>

All TCGA code tables are available at <https://gdc.cancer.gov/resources-tcga-users/tcga-code-tables/>

